﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "performance_monitor_task.h"
#if ENABLE_PERFORMANCE_MONITOR_SERVICE
#include "performance_monitor_service.h"
#include <nn/util/util_FormatString.h>
//==============================================================================
namespace tma { namespace performance_monitor {
//==============================================================================

//==============================================================================

Task::Task()
{
//NN_SDK_LOG( "[Task::Task( 0x%p )]\n", this );
    m_TaskType = tmipc::TaskType_PerformanceMonitorTask;
}

//==============================================================================

Task::~Task()
{
//NN_SDK_LOG( "[Task::~Task( 0x%p )]\n", this );
}

//==============================================================================

void Task::OnInitiate( tmipc::Packet* pPacket )
{
    s32 Result = 0;

    // Fill in the return packet.
    tmipc::Packet* pReturnPacket = AllocSendPacket();

    // Record a snapshot of the performance monitor information.
    Service* pService{ static_cast<Service*>(GetService()) };
    pService->RecordSnapShot();

    nn::os::Tick  ElapsedTimeTicks{ pService->GetEndTime() - pService->GetStartTime() };
    nn::TimeSpan  ElapsedTimeSpan{ ElapsedTimeTicks.ToTimeSpan() };
    const s64     ElapsedTimeMS{ ElapsedTimeSpan.GetMilliSeconds() };

// Helpful for debugging.
// - This should be maintained, even if commented out.
// - The printf uses | instead of \n, so be careful when copy/pasting.
    NN_SDK_LOG( "[Profile]!!! ET: %lld|"
                "TF: %lld|THIO: %lld|THTC: %lld|THTCS0: %lld|THTCS1: %lld|THTCS2: %lld|THTCS3: %lld|THTCS4: %lld|THTCS5: %lld|THTCS6: %lld|THTCS7: %lld|"
                "TMain: %lld|TPMan: %lld|TTLis: %lld|TTRec: %lld|TTSen: %lld|TTSes: %lld|TTSM: %lld|"
                "HIORB: %d|HIORC: %d|HIOWB: %d|HIOWC: %d|"
                "HTCSRB: %d|HTCSRC: %d|HTCSSB: %d|HTCSSC: %d|"
                "MA: %d|MT: %d|MAC: %d|MDC: %d|"
                "RBC: %d|RPC: %d|RPQA: %d|RPQT: %d|SBC: %d|SPC: %d|SPQA: %d|SPQT: %d|"
                "TCCa: %d|TCCo: %d|TCCu: %d|TCT: %d|"
                "WQC: %d|WQSC: %d|WQS: %d|WQMCC: %d\n",
                ElapsedTimeMS,

                pService->GetCPUFrequencyTicks(),
                pService->GetThreadTicksHio(),
                pService->GetThreadTicksHtc(),
                pService->GetThreadTicksHtcs0(),
                pService->GetThreadTicksHtcs1(),
                pService->GetThreadTicksHtcs2(),
                pService->GetThreadTicksHtcs3(),
                pService->GetThreadTicksHtcs4(),
                pService->GetThreadTicksHtcs5(),
                pService->GetThreadTicksHtcs6(),
                pService->GetThreadTicksHtcs7(),

                pService->GetThreadTicksMain(),
                pService->GetThreadTicksPowerManagement(),
                pService->GetThreadTicksTmipcListen(),
                pService->GetThreadTicksTmipcReceive(),
                pService->GetThreadTicksTmipcSend(),
                pService->GetThreadTicksTmipcSession(),
                pService->GetThreadTicksTmipcServicesManager(),

                pService->GetHostIOReadByteCount(),
                pService->GetHostIOReadCount(),
                pService->GetHostIOWriteByteCount(),
                pService->GetHostIOWriteCount(),

                pService->GetHTCSReceivedByteCount(),
                pService->GetHTCSReceivedCount(),
                pService->GetHTCSSentByteCount(),
                pService->GetHTCSSentCount(),

                pService->GetMemoryAllocated(),
                pService->GetMemoryTotal(),
                pService->GetMemoryAllocationCount(),
                pService->GetMemoryDeallocationCount(),

                pService->GetReceivedByteCount(),
                pService->GetReceivedPacketCount(),
                pService->GetReceivedPacketQueueAllocated(),
                pService->GetReceivedPacketQueueTotal(),
                pService->GetSentByteCount(),
                pService->GetSentPacketCount(),
                pService->GetSentPacketQueueAllocated(),
                pService->GetSentPacketQueueTotal(),

                pService->GetTaskCountCancelled(),
                pService->GetTaskCountCompleted(),
                pService->GetTaskCountCurrent(),

                pService->GetTaskCountTotal(),
                pService->GetWorkQueueCurrent(),
                pService->GetWorkQueueSubmitCount(),
                pService->GetWorkQueueSize(),
                pService->GetWorkQueueMaxConcurrentCount()
              );

    // Write data into the packet.
    pReturnPacket->WriteFormat( "ET: %lld\n"
                                "TF: %lld\nTHIO: %lld\nTHTC: %lld\nTHTCS0: %lld\nTHTCS1: %lld\nTHTCS2: %lld\nTHTCS3: %lld\nTHTCS4: %lld\nTHTCS5: %lld\nTHTCS6: %lld\nTHTCS7: %lld\n"
                                "TMain: %lld\nTPMan: %lld\nTTLis: %lld\nTTRec: %lld\nTTSen: %lld\nTTSes: %lld\nTTSM: %lld\n"
                                "HIORB: %d\nHIORC: %d\nHIOWB: %d\nHIOWC: %d\n"
                                "HTCSRB: %d\nHTCSRC: %d\nHTCSSB: %d\nHTCSSC: %d\n"
                                "MA: %d\nMT: %d\nMAC: %d\nMDC: %d\n"
                                "RBC: %d\nRPC: %d\nRPQA: %d\nRPQT: %d\nSBC: %d\nSPC: %d\nSPQA: %d\nSPQT: %d\n"
                                "TCCa: %d\nTCCo: %d\nTCCu: %d\nTCT: %d\n"
                                "WQC: %d\nWQSC: %d\nWQS: %d\nWQMCC: %d\n",
                                ElapsedTimeMS,

                                pService->GetCPUFrequencyTicks(),
                                pService->GetThreadTicksHio(),
                                pService->GetThreadTicksHtc(),
                                pService->GetThreadTicksHtcs0(),
                                pService->GetThreadTicksHtcs1(),
                                pService->GetThreadTicksHtcs2(),
                                pService->GetThreadTicksHtcs3(),
                                pService->GetThreadTicksHtcs4(),
                                pService->GetThreadTicksHtcs5(),
                                pService->GetThreadTicksHtcs6(),
                                pService->GetThreadTicksHtcs7(),

                                pService->GetThreadTicksMain(),
                                pService->GetThreadTicksPowerManagement(),
                                pService->GetThreadTicksTmipcListen(),
                                pService->GetThreadTicksTmipcReceive(),
                                pService->GetThreadTicksTmipcSend(),
                                pService->GetThreadTicksTmipcSession(),
                                pService->GetThreadTicksTmipcServicesManager(),

                                pService->GetHostIOReadByteCount(),
                                pService->GetHostIOReadCount(),
                                pService->GetHostIOWriteByteCount(),
                                pService->GetHostIOWriteCount(),

                                pService->GetHTCSReceivedByteCount(),
                                pService->GetHTCSReceivedCount(),
                                pService->GetHTCSSentByteCount(),
                                pService->GetHTCSSentCount(),

                                pService->GetMemoryAllocated(),
                                pService->GetMemoryTotal(),
                                pService->GetMemoryAllocationCount(),
                                pService->GetMemoryDeallocationCount(),

                                pService->GetReceivedByteCount(),
                                pService->GetReceivedPacketCount(),
                                pService->GetReceivedPacketQueueAllocated(),
                                pService->GetReceivedPacketQueueTotal(),
                                pService->GetSentByteCount(),
                                pService->GetSentPacketCount(),
                                pService->GetSentPacketQueueAllocated(),
                                pService->GetSentPacketQueueTotal(),

                                pService->GetTaskCountCancelled(),
                                pService->GetTaskCountCompleted(),
                                pService->GetTaskCountCurrent(),
                                pService->GetTaskCountTotal(),

                                pService->GetWorkQueueCurrent(),
                                pService->GetWorkQueueSubmitCount(),
                                pService->GetWorkQueueSize(),
                                pService->GetWorkQueueMaxConcurrentCount()
                              );

    m_pServicesManager->Send( pReturnPacket );

    // Task complete.
    Complete();
} // NOLINT(readability/fn_size)

//==============================================================================

void Task::OnRecvPacket( tmipc::Packet* pPacket )
{
    // No processing, just complete the task on a packet.
    (void)pPacket;
    Complete();
}

//==============================================================================

void Task::OnSendPacket( tmipc::Packet* pPacket )
{
    // TODO - Handle Packet
    (void)pPacket;
    ASSERT( 0 );
}

//==============================================================================
}}
//==============================================================================

#endif // ENABLE_PERFORMANCE_MONITOR_SERVICE
