﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// このファイルはユーザ定義

#include <nn/result/result_HandlingUtility.h>
#include <nn/htc/htc_Result.h>
#include <nn/os.h>
#include "htc_HtcManagerImpl.h"
#include "../connection/connection_Api.h"
#include "../env/env_api.h"
#include "../generic_service/generic_service_api.h"

#if defined(NN_BUILD_CONFIG_HARDWARE_BDSLIMX6) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || defined(NN_BUILD_CONFIG_HARDWARE_NX) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2)
#define NN_DETAIL_TMA_SUPPORT_HBX
#endif

#if defined(NN_DETAIL_TMA_SUPPORT_HBX)
#include "../hbx/hbx_api.h"
#endif

namespace nn { namespace tma {

nn::Result HtcManagerImpl::GetEnvironmentVariable(nn::sf::Out<std::int32_t> pOutSize, const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& variableName) NN_NOEXCEPT
{
    int32_t size;
    nn::Result result = env::GetEnvironmentVariableImpl( &size, outBuffer.GetPointerUnsafe(), static_cast<int32_t>(outBuffer.GetSize()), variableName.GetPointerUnsafe() );
    if( result.IsSuccess() )
    {
        pOutSize.Set(size);
    }
    return result;
}

nn::Result HtcManagerImpl::GetEnvironmentVariableLength(nn::sf::Out<std::int32_t> pOutValue, const nn::sf::InBuffer& variableName) NN_NOEXCEPT
{
    int32_t size;
    nn::Result result = env::GetEnvironmentVariableLength( &size, variableName.GetPointerUnsafe() );
    if( result.IsSuccess() )
    {
        pOutValue.Set(size);
    }
    return result;
}

nn::Result HtcManagerImpl::GetHostConnectionEvent(nn::sf::Out<nn::sf::NativeHandle> pOutValue) NN_NOEXCEPT
{
    nn::os::NativeHandle internalHandle;

    internalHandle = nn::os::GetReadableHandleOfSystemEvent(nn::tma::connection::GetConnectionEvent());

    pOutValue.Set( nn::sf::NativeHandle( internalHandle, false ) );

    NN_RESULT_SUCCESS;
}

nn::Result HtcManagerImpl::GetHostDisconnectionEvent(nn::sf::Out<nn::sf::NativeHandle> pOutValue) NN_NOEXCEPT
{
    nn::os::NativeHandle internalHandle;

    internalHandle = nn::os::GetReadableHandleOfSystemEvent(nn::tma::connection::GetDisconnectionEvent());

    pOutValue.Set(nn::sf::NativeHandle(internalHandle, false));

    NN_RESULT_SUCCESS;
}

nn::Result HtcManagerImpl::GetHostConnectionEventForSystem(nn::sf::Out<nn::sf::NativeHandle> pOutValue) NN_NOEXCEPT
{
    nn::os::NativeHandle internalHandle;

    internalHandle = nn::os::GetReadableHandleOfSystemEvent(nn::tma::connection::GetConnectionEventForSystem());

    pOutValue.Set(nn::sf::NativeHandle(internalHandle, false));

    NN_RESULT_SUCCESS;
}

nn::Result HtcManagerImpl::GetHostDisconnectionEventForSystem(nn::sf::Out<nn::sf::NativeHandle> pOutValue) NN_NOEXCEPT
{
    nn::os::NativeHandle internalHandle;

    internalHandle = nn::os::GetReadableHandleOfSystemEvent(nn::tma::connection::GetDisconnectionEventForSystem());

    pOutValue.Set(nn::sf::NativeHandle(internalHandle, false));

    NN_RESULT_SUCCESS;
}

nn::Result HtcManagerImpl::GetBridgeIpAddress(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
{
#if defined(NN_DETAIL_TMA_SUPPORT_HBX)
    return bridge_api::GetBridgeIpAddress( outBuffer.GetPointerUnsafe(), static_cast<int32_t>(outBuffer.GetSize()) );
#else
    NN_UNUSED(outBuffer);

    NN_RESULT_SUCCESS;
#endif
}

nn::Result HtcManagerImpl::GetBridgeSubnetMask(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
{
#if defined(NN_DETAIL_TMA_SUPPORT_HBX)
    return bridge_api::GetBridgeSubnetMask( outBuffer.GetPointerUnsafe(), static_cast<int32_t>(outBuffer.GetSize()) );
#else
    NN_UNUSED(outBuffer);

    NN_RESULT_SUCCESS;
#endif
}

nn::Result HtcManagerImpl::GetBridgeMacAddress(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
{
#if defined(NN_DETAIL_TMA_SUPPORT_HBX)
    return bridge_api::GetBridgeMacAddress( outBuffer.GetPointerUnsafe(), static_cast<int32_t>(outBuffer.GetSize()) );
#else
    NN_UNUSED(outBuffer);

    NN_RESULT_SUCCESS;
#endif

}

nn::Result HtcManagerImpl::GetBridgePort(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
{
#if defined(NN_DETAIL_TMA_SUPPORT_HBX)
    return bridge_api::GetBridgePort( outBuffer.GetPointerUnsafe(), static_cast<int32_t>(outBuffer.GetSize()) );
#else
    NN_UNUSED(outBuffer);

    NN_RESULT_SUCCESS;
#endif
}

nn::Result HtcManagerImpl::SetCradleAttached(bool bAttached) NN_NOEXCEPT
{
#if defined(NN_DETAIL_TMA_SUPPORT_HBX)
    return bridge_api::SetCradleAttached(bAttached);
#else
    NN_UNUSED(bAttached);

    NN_RESULT_SUCCESS;
#endif
}

nn::Result HtcManagerImpl::GetWorkingDirectoryPath(const nn::sf::OutBuffer& outBuffer, const int32_t bufferSize) NN_NOEXCEPT
{
    nn::Result result = generic_service::GetWorkingDirectoryPathImpl(outBuffer.GetPointerUnsafe(), bufferSize);
    return result;
}

nn::Result HtcManagerImpl::GetWorkingDirectoryPathSize(nn::sf::Out<std::int32_t> pOutValue) NN_NOEXCEPT
{
    int32_t size;
    nn::Result result = generic_service::GetWorkingDirectoryPathSize(&size);
    if( result.IsSuccess() )
    {
        pOutValue.Set(size);
    }
    return result;
}


}}
