﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmagent.h"
#include "..\tma\tma_MQ.h"
#include "..\tmipc\tmipc_task.h"
#include "..\tmipc\tmipc_packet.h"
#include "..\tmipc\tmipc_service.h"
#include "hio_task.h"
#undef DeleteFile

//==============================================================================
namespace tma { namespace hio {
//==============================================================================

enum TMAgent_host_io_message_type
{
    TMAGENT_HOST_IO_MESSAGE_TYPE_UNKNOWN,
    TMAGENT_HOST_IO_MESSAGE_TYPE_OPEN,
    TMAGENT_HOST_IO_MESSAGE_TYPE_CLOSE,
    TMAGENT_HOST_IO_MESSAGE_TYPE_GET_SIZE,
    TMAGENT_HOST_IO_MESSAGE_TYPE_READ,
    TMAGENT_HOST_IO_MESSAGE_TYPE_SIZEOF,
};

class AgentHostIOService : public tmipc::Service
{
private:

public:
                        AgentHostIOService  ();
                       ~AgentHostIOService  ();

        void            Init                    ( void );
        void            Kill                    ( void );

        HostIOExistsTask*        FileExists         ( const char*               pFullPath );

        HostIOCreateTask*        CreateFile         ( const char*               pFullPath,
                                                      int64_t                   Size );

        HostIODeleteTask*        DeleteFile         ( const char*               pFullPath );

        HostIORenameTask*        RenameFile         ( const char*               pFromPath,
                                                      const char*               pToPath );

        HostIOOpenTask*          OpenFile           ( uint32_t                  OpenFlags,
                                                      const char*               pFullPath );

        HostIOFlushTask*         FlushFile          ( TMA_HOSTIO_FILE_HANDLE    FileHandle );

        HostIOGetSizeTask*       GetFileSize        ( TMA_HOSTIO_FILE_HANDLE    FileHandle );

        HostIOGetSizeFromPathTask* GetFileSize      ( const char*               pFullPath );

        HostIOGetFileTimeStampTask* GetFileTimeStamp( const char*               pFullPath );

        HostIOSetSizeTask*       SetFileSize        ( TMA_HOSTIO_FILE_HANDLE    FileHandle,
                                                      s64                       Size );

        HostIOSetPriorityTask*   SetFilePriority    ( TMA_HOSTIO_FILE_HANDLE    FileHandle,
                                                      s32                       Priority );

        HostIOGetPriorityTask*   GetFilePriority    ( TMA_HOSTIO_FILE_HANDLE FileHandle );

        HostIOReadTask*          ReadFile           ( int32_t*                  pBytesRead,
                                                      TMA_HOSTIO_FILE_HANDLE    FileHandle,
                                                      int64_t                   Offset,
                                                      void*                     pDataBuffer,
                                                      int64_t                   AmountToRead );

        HostIOWriteTask*         WriteFile          ( int32_t*                  pBytesWritten,
                                                      TMA_HOSTIO_FILE_HANDLE    FileHandle,
                                                      int64_t                   Offset,
                                                      void*                     pDataBuffer,
                                                      int64_t                   AmountToWrite );

        HostIOCloseTask*         CloseFile          ( TMA_HOSTIO_FILE_HANDLE    FileHandle );

        HostIOGetIOTypeTask*     GetIOType          ( const char*               pFullPath );

    //Task types
    enum tasks
    {
        TaskTypeIO      = 0,    // Standard IO task - Read and write handled separately
        TaskTypeRead    = 1,
        TaskTypeWrite   = 2,
    };

protected:
virtual tmipc::Task*    OnNewTask  ( tmipc::Packet*             pPacket );

};

//==============================================================================
// Global IO service object.
AgentHostIOService&     GetHostIOService( void );

//==============================================================================
}}
//==============================================================================
