﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "..\tmagent.h"
#include "hio_directory_task.h"
#include "hio_directory_service.h"
#include "hio_opcodes.h"


//==============================================================================
namespace tma { namespace hio {
//==============================================================================

//==============================================================================

AgentHostDirectoryIOService::AgentHostDirectoryIOService()
{
    DEJA_TRACE( "AgentHostDirectoryIOService::AgentHostDirectoryIOService", "AgentHostDirectoryIOService" );
    m_ServiceId = HashString( "HostDirectoryIOService" );
}

//==============================================================================

AgentHostDirectoryIOService::~AgentHostDirectoryIOService()
{
    DEJA_TRACE( "AgentHostDirectoryIOService::~AgentHostDirectoryIOService", "~AgentHostDirectoryIOService" );
}

//==============================================================================

void AgentHostDirectoryIOService::Init()
{
    DEJA_TRACE( "AgentHostDirectoryIOService::Init", "Init" );
    Create();
}

//==============================================================================

void AgentHostDirectoryIOService::Kill()
{
    DEJA_TRACE( "AgentHostDirectoryIOService::Kill", "Kill" );
    Destroy();
}

//==============================================================================

tmipc::Task* AgentHostDirectoryIOService::OnNewTask( tmipc::Packet* pPacket )
{
    (void)pPacket;
    DEJA_TRACE( "AgentHostDirectoryIOService::OnInitiate", "OnInitiate" );
    ASSERT( 0 );
    return( NULL );
}

//==============================================================================

template <class T> T* AgentHostDirectoryIOService::CreateTask( TMA_HOSTIO_DIRECTORY_HANDLE Handle )
{
    void* pMem = s_Allocate( sizeof( T ) );
    ASSERT( pMem );
    T* pTask = new (pMem) T( Handle );
    ASSERT(pTask && "Failed to allocate a new task.");
    pTask->SetServicesManager( m_pServicesManager );
    pTask->SetServiceId( m_ServiceId );
    pTask->SetTaskId( m_pServicesManager->AllocTaskId() );
    return pTask;
}

//==============================================================================

HostDirectoryIOExistsTask* AgentHostDirectoryIOService::DirectoryExists( const char* pFullPath )
{
    DEJA_TRACE( "AgentHostDirectoryIOService::DirectoryExists", "DirectoryExists for path %s", pFullPath );
    HostDirectoryIOExistsTask* pTask = CreateTask<HostDirectoryIOExistsTask>( INVALID_HOSTIO_DIRECTORY_HANDLE );
    pTask->Exists( pFullPath );
    return pTask;
}

//==============================================================================

HostDirectoryIOOpenTask* AgentHostDirectoryIOService::OpenDirectory( TMA_HOSTIO_DIRECTORY_HANDLE* pHandle, const char* pathName, int32_t OpenMode )
{
    DEJA_TRACE( "AgentHostDirectoryIOService::OpenDirectory", "OpenDirectory %s", pathName );
    HostDirectoryIOOpenTask* pTask = CreateTask<HostDirectoryIOOpenTask>( INVALID_HOSTIO_DIRECTORY_HANDLE );
    pTask->Open( pHandle, pathName, OpenMode );
    return pTask;

}

//==============================================================================

HostDirectoryIOGetEntryCountTask* AgentHostDirectoryIOService::GetDirectoryCount( TMA_HOSTIO_DIRECTORY_HANDLE DirectoryHandle )
{
    DEJA_TRACE( "AgentHostDirectoryIOService::GetDirectoryCount", "GetDirectoryCount for handle %lld", DirectoryHandle );
    HostDirectoryIOGetEntryCountTask* pTask = CreateTask<HostDirectoryIOGetEntryCountTask>( DirectoryHandle );
    pTask->GetEntryCount();
    return pTask;
}

//==============================================================================

HostDirectoryIOReadTask* AgentHostDirectoryIOService::ReadDirectory( int64_t* pOut, TMA_HOSTIO_DIRECTORY_HANDLE DirectoryHandle, nn::fs::DirectoryEntry pEntries[], int64_t numEntries )
{
    DEJA_TRACE( "AgentHostDirectoryIOService::ReadDirectory", "ReadDirectory: Entries = %p, NumEntries = %lld", pEntries, numEntries );
    HostDirectoryIOReadTask* pTask = CreateTask<HostDirectoryIOReadTask>( DirectoryHandle );
    pTask->Read( pOut, pEntries, numEntries );
    return pTask;
}

//==============================================================================

HostDirectoryIOCloseTask* AgentHostDirectoryIOService::CloseDirectory( TMA_HOSTIO_DIRECTORY_HANDLE DirectoryHandle )
{
    DEJA_TRACE( "AgentHostDirectoryIOService::CloseDirectory", "CloseDirectory for handle %lld", DirectoryHandle );
    HostDirectoryIOCloseTask* pTask = CreateTask<HostDirectoryIOCloseTask>( DirectoryHandle );
    pTask->Close();
    return pTask;
}

//==============================================================================

HostDirectoryIOSetPriorityTask* AgentHostDirectoryIOService::SetDirectoryPriority( TMA_HOSTIO_DIRECTORY_HANDLE DirectoryHandle, s32 Priority )
{
    DEJA_TRACE( "AgentHostDirectoryIOService::SetDirectoryPriority", "SetDirectoryPriority for handle %lld", DirectoryHandle );
    HostDirectoryIOSetPriorityTask* pTask = CreateTask<HostDirectoryIOSetPriorityTask>( DirectoryHandle );
    pTask->SetPriority( Priority );
    return pTask;
}

//==============================================================================

HostDirectoryIOGetPriorityTask* AgentHostDirectoryIOService::GetDirectoryPriority( TMA_HOSTIO_DIRECTORY_HANDLE DirectoryHandle )
{
    DEJA_TRACE( "AgentHostDirectoryIOService::GetDirectoryPriority", "GetDirectoryPriority for handle %lld", DirectoryHandle );
    HostDirectoryIOGetPriorityTask* pTask = CreateTask<HostDirectoryIOGetPriorityTask>( DirectoryHandle );
    pTask->GetPriority();
    return pTask;
}

//==============================================================================

HostDirectoryIOCreateTask* AgentHostDirectoryIOService::CreateDirectory( const char* pFullPath )
{
    DEJA_TRACE( "AgentHostDirectoryIOService::CreateDirectory", "CreateDirectory %s", pFullPath );
    HostDirectoryIOCreateTask* pTask = CreateTask<HostDirectoryIOCreateTask>( INVALID_HOSTIO_DIRECTORY_HANDLE );
    pTask->Create( pFullPath );
    return pTask;
}

//==============================================================================

HostDirectoryIODeleteTask* AgentHostDirectoryIOService::DeleteDirectory( const char* pFullPath, int32_t Recursively )
{
    DEJA_TRACE( "AgentHostDirectoryIOService::DeleteDirectory", "DeleteDirectory %s", pFullPath );
    HostDirectoryIODeleteTask* pTask = CreateTask<HostDirectoryIODeleteTask>( INVALID_HOSTIO_DIRECTORY_HANDLE );
    pTask->Delete( pFullPath, (u8)Recursively );
    return pTask;
}

//==============================================================================

HostDirectoryIORenameTask* AgentHostDirectoryIOService::RenameDirectory( const char* pFromPath, const char* pToPath )
{
    DEJA_TRACE( "AgentHostDirectoryIOService::RenameDirectory", "RenameDirectory %s to %s", pFromPath, pToPath );
    HostDirectoryIORenameTask* pTask = CreateTask<HostDirectoryIORenameTask>( INVALID_HOSTIO_DIRECTORY_HANDLE );
    pTask->Rename( pFromPath, pToPath );
    return pTask;
}


//==============================================================================
}}
//==============================================================================
