﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// このファイルはユーザ定義

#include "hio_FileAccessorImpl.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace tma {

FileAccessorImpl::FileAccessorImpl(file_io::TMA_FILE_HANDLE handle) NN_NOEXCEPT
{
    m_Handle = handle;
}

FileAccessorImpl::~FileAccessorImpl() NN_NOEXCEPT
{
    file_io::CloseFile( m_Handle );
}

nn::Result FileAccessorImpl::ReadFileForFs0(nn::sf::Out<std::int32_t> pOut, std::int64_t offset, const nn::sf::OutBuffer& pBuffer) NN_NOEXCEPT
{
    std::int32_t out;
    NN_RESULT_DO( file_io::ReadFile( &out, m_Handle, offset, pBuffer.GetPointerUnsafe(), pBuffer.GetSize() ) );
    pOut.Set( out );
    NN_RESULT_SUCCESS;
}

nn::Result FileAccessorImpl::ReadFile(nn::sf::Out<std::int64_t> pOut, std::int64_t offset, const nn::sf::OutBuffer& pBuffer, nn::fs::ReadOption option) NN_NOEXCEPT
{
    size_t out;
    NN_RESULT_DO( file_io::ReadFile( &out, m_Handle, offset, pBuffer.GetPointerUnsafe(), pBuffer.GetSize(), option ) );
    pOut.Set( out );
    NN_RESULT_SUCCESS;
}

nn::Result FileAccessorImpl::WriteFileForFs0(nn::sf::Out<std::int32_t> pOut, std::int64_t offset, const nn::sf::InBuffer& pBuffer, bool flush) NN_NOEXCEPT
{
    std::int32_t out;
    NN_RESULT_DO( file_io::WriteFile( &out, m_Handle, offset, pBuffer.GetPointerUnsafe(), pBuffer.GetSize(), flush ) );
    pOut.Set( out );
    NN_RESULT_SUCCESS;
}

nn::Result FileAccessorImpl::WriteFile(std::int64_t offset, const nn::sf::InBuffer& pBuffer, nn::fs::WriteOption option) NN_NOEXCEPT
{
    return file_io::WriteFile( m_Handle, offset, pBuffer.GetPointerUnsafe(), pBuffer.GetSize(), option );
}

nn::Result FileAccessorImpl::GetFileSize(nn::sf::Out<std::int64_t> pOut) NN_NOEXCEPT
{
    std::int64_t out;
    NN_RESULT_DO( file_io::GetFileSize( &out, m_Handle ) );
    pOut.Set( out );
    NN_RESULT_SUCCESS;
}

nn::Result FileAccessorImpl::SetFileSize(std::int64_t size) NN_NOEXCEPT
{
    return file_io::SetFileSize( m_Handle, size );
}

nn::Result FileAccessorImpl::FlushFile() NN_NOEXCEPT
{
    return file_io::FlushFile( m_Handle );
}

nn::Result FileAccessorImpl::SetPriorityForFile(std::int32_t priority) NN_NOEXCEPT
{
    return file_io::SetPriorityForFile( m_Handle, priority );
}

nn::Result FileAccessorImpl::GetPriorityForFile(nn::sf::Out<std::int32_t> pOut) NN_NOEXCEPT
{
    std::int32_t out;
    NN_RESULT_DO( file_io::GetPriorityForFile( &out, m_Handle ) );
    pOut.Set( out );
    NN_RESULT_SUCCESS;
}

}}
