﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/tma/sf/tma_IFileManager.h>
#include "hio_api.h"

namespace nn { namespace tma {

class DirectoryAccessorImpl
{
public:
    explicit DirectoryAccessorImpl(directory_io::TMA_DIR_HANDLE handle) NN_NOEXCEPT;
    ~DirectoryAccessorImpl() NN_NOEXCEPT;
    nn::Result GetEntryCount(nn::sf::Out<std::int64_t> pCount) NN_NOEXCEPT;
    nn::Result ReadDirectory(nn::sf::Out<std::int64_t> pOut, const nn::sf::OutArray<nn::fs::DirectoryEntry>& pEntries) NN_NOEXCEPT;
    nn::Result SetPriorityForDirectory(std::int32_t priority) NN_NOEXCEPT;
    nn::Result GetPriorityForDirectory(nn::sf::Out<std::int32_t> pOut) NN_NOEXCEPT;
private:
    directory_io::TMA_DIR_HANDLE m_Handle;
};

}}
