﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//==============================================================================
namespace tma{ namespace hid {
//==============================================================================

#define TMA_FOURCC( a, b, c, d ) (((int)a << 24) | ((int)b << 16) | ((int)c << 8) | ((int)d))

enum controller_type
{
    CONTROLLER_UNKNOWN              = TMA_FOURCC( 'U','N','K','N' ),
    CONTROLLER_TYPE_BASE            = TMA_FOURCC( 'B','A','S','E' ),
    CONTROLLER_TYPE_WII_REMOTE      = TMA_FOURCC( 'W','I','I','R' ),
    CONTROLLER_TYPE_WII_CLASSIC_PRO = TMA_FOURCC( 'W','C','C','P' ),
};

//==============================================================================
//  controller_data
//==============================================================================

struct controller_data
{
    int32_t     m_Type;
    int32_t     m_Size;
    int32_t     m_Port;
    bool        m_bConnected;
};

//==============================================================================
//  wii_classic_pro_data
//==============================================================================

struct wii_classic_pro_data : public controller_data
{
    uint32_t    m_ButtonStates;
    int32_t     m_AxisStates[4];
};

//==============================================================================
}}  // Namespace tma::hid
//==============================================================================
