﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "hid_api.h"
#include "hid_Service.h"
#include "hid_Task.h"
#include "hid_opcodes.h"
#include "../tm_result.h"

//==============================================================================
namespace nn{ namespace tma { namespace hid {
//==============================================================================

Result GetControllerState( int32_t ControllerID, void* pBuffer, uint32_t BufferSize )
{
    bool bValid = false;
    ::tma::hid::AgentControllerService& ControllerService = ::tma::hid::GetControllerService();

    if( BufferSize >= ControllerService.GetControllerBufferSzie() )
    {
        bValid = ControllerService.GetControllerState( ControllerID, pBuffer );
    }

    if( bValid )
    {
        return ResultSuccess();
    }
    else
    {
        return result::detail::ConstructResult( tmapi::RESULT_INVALID_CONTROLLER );
    }
}

//==============================================================================

Result GetKeyboardInput( int32_t& Character )
{
    ::tma::hid::AgentControllerService& ControllerService = ::tma::hid::GetControllerService();

    ControllerService.GetKeyboardInput( Character );

    return ResultSuccess();
}

//==============================================================================
}}} // namepsace nn::tma::hid
//==============================================================================
