﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "hbx_api.h"
#include <nn/nn_SdkLog.h>
#include <HotBridgeAPI.h>
#include <nn/tma/tma_Result.h>

#include "..\tmipc\tmipc_node_tics_interface.h"

//==============================================================================
namespace nn { namespace tma {
//==============================================================================

//==============================================================================
namespace bridge_api {
//==============================================================================

// TICS Transport
tmipc::NodeTICS* s_pAgentNodeTICS = nullptr;

//==============================================================================

void Initialize( tmipc::NodeTICS* AgentNode )
{
    s_pAgentNodeTICS = AgentNode;
}

void Finalize( )
{
    s_pAgentNodeTICS = nullptr;
}

nn::Result SetSleepStatus( bool bSleep )
{
    if( s_pAgentNodeTICS == nullptr )
        return nn::os::ResultNotSupported();

    tmipc::TICSInterface::SetTargetStatusFlag( tics::EFlag_TargetSleep, bSleep );

    return( nn::ResultSuccess() );
}

nn::Result SetCradleAttached( bool bAttached )
{
    if( s_pAgentNodeTICS == nullptr )
        return nn::os::ResultNotSupported();

    tmipc::TICSInterface::SetTargetStatusFlag( tics::EFlag_TargetCradleAttached, !bAttached );

    return( nn::ResultSuccess() );
}

nn::Result ConfigSectionAttrGet( const char* sectionName, const char *attrName, char *attrValue, int attrValueLen )
{
    if( s_pAgentNodeTICS == nullptr )
        return nn::os::ResultNotSupported();

    size_t sectionNameSize = sizeof(char) * (strlen(sectionName) + 1);
    size_t attrNameSize    = sizeof(char) * (strlen(attrName) + 1);

    tmipc::Result Result = tmipc::TICSInterface::ConfigSectionAttrGet( sectionName, attrName, attrValue, attrValueLen );

    if (Result == tmipc::TMIPC_RESULT_OK)
    {
        return( nn::ResultSuccess() );
    }
    else
    {
        return( nn::tma::ResultUnknown() );
    }
}

nn::Result GetBridgeIpAddress( char *ipAddress, int ipAddressLen )
{
    const char *sectionName = "BridgeSettings";
    const char *attrName    = "ip";

    return ConfigSectionAttrGet( sectionName, attrName, ipAddress, ipAddressLen );
}

nn::Result GetBridgeSubnetMask( char *subnetMask, int subnetMaskLen )
{
    const char *sectionName = "BridgeSettings";
    const char *attrName    = "netmask";

    return ConfigSectionAttrGet( sectionName, attrName, subnetMask, subnetMaskLen );
}

nn::Result GetBridgeMacAddress( char *macAddress, int macAddressLen )
{
    const char *sectionName = "BridgeSettings";
    const char *attrName    = "mac";

    return ConfigSectionAttrGet( sectionName, attrName, macAddress, macAddressLen );
}

nn::Result GetBridgePort( char *port, int portLen )
{
    const char *sectionName = "BridgeSettings";
    const char *attrName    = "port";

    return ConfigSectionAttrGet( sectionName, attrName, port, portLen );
}

//==============================================================================
} //bridge_api namespace
//==============================================================================

//==============================================================================
}} //nn::tma namespace
//==============================================================================

