﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//==============================================================================
//  INCLUDES
//==============================================================================

#include "../tmipc/tmipc_service.h"
#include "get_working_directory_path_size_task.h"
#include "get_working_directory_path_task.h"

//==============================================================================
namespace tma { namespace generic_service {
//==============================================================================

class Service : public tmipc::Service
{
protected:

    virtual tmipc::Task*    OnNewTask( tmipc::Packet*    pPacket );

public:
                    Service ();
                   ~Service ();

            void    Init    ();
            void    Kill    ();

            GetWorkingDirectoryPathTask::Result     GetWorkingDirectoryPath     ( char*     pBuffer,
                                                                                  int32_t   bufferLength ) NN_NOEXCEPT;

            GetWorkingDirectoryPathSizeTask::Result GetWorkingDirectoryPathSize ( int32_t*  pLength ) NN_NOEXCEPT;
};

//==============================================================================
// Global Working Directory service object.
Service& GetService();

//==============================================================================
}}
//==============================================================================
