﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "diagnostics_service.h"
#include "diagnostics_task.h"
#include "..\htcs\htcs_service.h"
#define REPORT_ON_TASK_LIST TMA_MACRO_VALUE(0)

#if DEBUG
#define DIAGNOSTICS_LOG(...) NN_SDK_LOG( "[tma][diagnostics] - " ); NN_SDK_LOG( __VA_ARGS__ ); NN_SDK_LOG( "\n" )
#else
#define DIAGNOSTICS_LOG(...)
#endif

//==============================================================================
namespace tma { namespace diagnostics {
//==============================================================================

Service::Service( )
{
    m_ServiceId = HashString( "TMADiagnosticsService" );
    DIAGNOSTICS_LOG( "Service::Service" );
}

//==============================================================================

Service::~Service()
{
    DIAGNOSTICS_LOG( "Service::~Service" );
}

//==============================================================================

void Service::Init()
{
    DIAGNOSTICS_LOG( "Service::Init" );
    Create();
}

//==============================================================================

void Service::Kill()
{
    DIAGNOSTICS_LOG( "Service::Kill" );
    Destroy();
}

//==============================================================================

tmipc::Task* Service::OnNewTask( tmipc::Packet* pPacket )
{
    DIAGNOSTICS_LOG( "Service::OnNewTask:  %d", pPacket->GetTaskType() );
    tmipc::Task* pRet = NULL;
    void* pMem = NULL;

    switch( pPacket->GetTaskType() )
    {
        case tmipc::TaskType_DiagnosticsTask:
            pMem = s_Allocate( sizeof(DiagnosticsTask) );
            pRet = new (pMem) DiagnosticsTask();
            break;

        default:
            DEJA_ERROR( "tma::diagnostics::Service::OnNewTask", "Unrecognized task type 0x%08x", pPacket->GetTaskType() );
            ASSERT( 0 );
            break;
    }

    if( pRet )
    {
        pRet->SetServicesManager( m_pServicesManager );
        pRet->SetServiceId( m_ServiceId );
        pRet->SetTaskId( pPacket->GetTaskId() );
        pRet->SetTaskType( (s16)pPacket->GetTaskType() );
        pRet->OnInitiate( pPacket );
    }

    return( pRet );
}

//==============================================================================
}} // namespace
//==============================================================================
