﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "dbg_CommandArgs.h"

//==============================================================================
namespace tma { namespace dbg { namespace CoreDump {
//==============================================================================

        nn::Result              Generate        ( Process*          pProcess,
                                                  char*             pOutputName,
                                                  bool              QuickDump );

        nn::Result              Initiate        ( Process*          pProcess,
                                                  char*             pOutputName,
                                                  bool              QuickDump );
        nn::Result              Continue        ( Process*          pProcess,
                                                  s32*              pPercentDone );
        nn::Result              AddTTY          ( Process*          pProcess,
                                                  char*             pData,
                                                  u32               SizeOfData );
        nn::Result              AddImage        ( Process*          pProcess,
                                                  char*             pData,
                                                  u32               SizeOfData );
        nn::Result              Close           ( Process*          pProcess );

//==============================================================================
}}} // namespace
//==============================================================================
