﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "benchmark_report_task.h"
#if ENABLE_BENCHMARK_TESTING
#include "benchmark_report_service.h"

//==============================================================================
namespace tma { namespace benchmark {
//==============================================================================

//==============================================================================

BenchmarkReportTask::BenchmarkReportTask()
{
//NN_SDK_LOG( "[BenchmarkReportTask::BenchmarkReportTask( 0x%p )]\n", this );
    m_TaskType = tmipc::TaskType_BenchmarkReport;
}

//==============================================================================

BenchmarkReportTask::~BenchmarkReportTask()
{
//NN_SDK_LOG( "[BenchmarkReportTask::~BenchmarkReportTask( 0x%p )]\n", this );
}

//==============================================================================

void BenchmarkReportTask::OnInitiate( tmipc::Packet* pPacket )
{
    s32 Result = 0;
//NN_SDK_LOG( "[BenchmarkReportTask::OnInitiate( 0x%p )]\n", this );

    // Fill in the return packet.
    tmipc::Packet* pReturnPacket = AllocSendPacket();

    s32 S32Type = { 0 };
    pPacket->ReadS32( S32Type );
    const Type type = static_cast<BenchmarkReportTask::Type>(S32Type);
    switch( type )
    {
    case Type::Start:
    {
NN_SDK_LOG( "[Ping benchmark] Start \n" );
        pReturnPacket->WriteS32( static_cast<s32>(Type::Start) );
        reinterpret_cast<BenchmarkReportService *>(GetService())->Start();
    }
    break;
    case Type::Stop:
    {
NN_SDK_LOG( "[Ping benchmark] Stop\n" );
        pReturnPacket->WriteS32( static_cast<s32>(Type::Stop) );
        reinterpret_cast<BenchmarkReportService *>(GetService())->Stop();
    }
    break;
    case Type::GetReport:
    {
NN_SDK_LOG( "[Ping benchmark] GetReport\n" );
        pReturnPacket->WriteS32( static_cast<s32>(Type::GetReport) );
        reinterpret_cast<BenchmarkReportService *>(GetService())->GenerateReport( *pReturnPacket );
    }
    break;
    default:
NN_SDK_LOG( "[Ping benchmark] - Unknown Type: %d\n", type );
        break;
    }

    m_pServicesManager->Send( pReturnPacket );

    // Task complete.
    Complete();
}

//==============================================================================

void BenchmarkReportTask::OnRecvPacket( tmipc::Packet* pPacket )
{
    // No processing, just complete the task on a packet.
    (void)pPacket;
    Complete();
}

//==============================================================================

void BenchmarkReportTask::OnSendPacket( tmipc::Packet* pPacket )
{
    // TODO - Handle Packet
    (void)pPacket;
    ASSERT( 0 );
}

//==============================================================================
}}
//==============================================================================

#endif // ENABLE_BENCHMARK_TESTING
