﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;

namespace nn.timesrv.detail.service
{
    [CppRefPath(@"<nn/timesrv/detail/service/timesrv_IServiceObject.sfdl.h>")]
    public interface IStaticService : IServiceObject
    {
        [MethodId(0)]
        Result GetStandardUserSystemClock(Out<ISystemClock> outStandardUserSystemClock);

        [MethodId(1)]
        Result GetStandardNetworkSystemClock(Out<ISystemClock> outStandardNetworkSystemClock);

        [MethodId(2)]
        Result GetStandardSteadyClock(Out<ISteadyClock> outStandardSteadyClock);

        [MethodId(3)]
        Result GetTimeZoneService(Out<ITimeZoneService> outTimeZoneService);

        [MethodId(4)]
        Result GetStandardLocalSystemClock(Out<ISystemClock> outStandardLocalSystemClock);

        [MethodId(5)]
        Result GetEphemeralNetworkSystemClock(Out<ISystemClock> outEphemeralNetworkSystemClock);

        [MethodId(20)]
        Result GetSharedMemoryNativeHandle(Out<nn.sf.NativeHandle> outHandle);

        [MethodId(50)]
        Result SetStandardSteadyClockInternalOffset(nn.TimeSpanType internalOffset);

        [MethodId(100)]
        Result IsStandardUserSystemClockAutomaticCorrectionEnabled(Out<bool> outValue);

        [MethodId(101)]
        Result SetStandardUserSystemClockAutomaticCorrectionEnabled(bool value);

        [MethodId(102)]
        Result GetStandardUserSystemClockInitialYear(Out<int32_t> outValue);

        [MethodId(200)]
        Result IsStandardNetworkSystemClockAccuracySufficient(Out<bool> outValue);

        [MethodId(201)]
        Result GetStandardUserSystemClockAutomaticCorrectionUpdatedTime(
            Out<nn.time.SteadyClockTimePoint> outValue);

        [MethodId(300)]
        Result CalculateMonotonicSystemClockBaseTimePoint(
            Out<int64_t> outValue,
            nn.time.SystemClockContext systemClockContext);

        [MethodId(400)]
        Result GetClockSnapshot(Out<nn.time.sf.ClockSnapshot> outValue, uint8_t initialType);

        [MethodId(401)]
        Result GetClockSnapshotFromSystemClockContext(
            Out<nn.time.sf.ClockSnapshot> outValue,
            nn.time.SystemClockContext userSystemClockContext,
            nn.time.SystemClockContext netSystemClockContext,
            uint8_t initialType);

        [MethodId(500)]
        Result CalculateStandardUserSystemClockDifferenceByUser(
            Out<nn.TimeSpanType> outValue,
            nn.time.sf.ClockSnapshot from,
            nn.time.sf.ClockSnapshot to);

        [MethodId(501)]
        Result CalculateSpanBetween(
            Out<nn.TimeSpanType> outValue,
            nn.time.sf.ClockSnapshot from,
            nn.time.sf.ClockSnapshot to);

    }
}
