﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/timesrv/detail/service/timesrv_HipcServerManager.h>

#include <nn/timesrv/detail/service/timesrv_ServiceNames.h>
#include <nn/timesrv/detail/service/timesrv_ServiceProvider.h>
#include <nn/timesrv/detail/service/timesrv_Capabilities.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace service
{

#if NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_TIME_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC

namespace
{
#if defined(NN_BUILD_CONFIG_OS_WIN)
    // 特権付き初期化時に通常 Initialize 済であっても,特権付きで IPC を開きなおすような処理にはなっていない.
    // windows 上では複数アプリが1バイナリになる関係で,開発者が意図せず,既に通常初期化されている状況になる可能性があるので,
    // 以下のフラグはすべて true にして, windows では nn::time::ResultNoCapability は発生しないようにしておく.
    // ※InitializeForMenu 関数の実装部分のコメントも参照してみてください
    const Capabilities g_UserCapabilities = { true, true, true, true, true };
    const Capabilities g_AdminCapabilities = { true, true, true ,true, true };
    const Capabilities g_SystemCapabilities = { true, true, true, true, true };
    const Capabilities g_RepairCapabilities = { true, true, true, true, true };
#else
    const Capabilities g_UserCapabilities = { false, false, false, false, false };
    const Capabilities g_AdminCapabilities = { true, true, false, true, false };
    const Capabilities g_SystemCapabilities = { false, false, true, false, false };
    const Capabilities g_RepairCapabilities = { false, false, false, false, true };
#endif
}

HipcServerManager::HipcServerManager(ServiceProvider* pServiceProvider) NN_NOEXCEPT
    : m_SfExpHeapAllocator(nn::lmem::CreationOption_NoOption),
      m_UserStaticService(g_UserCapabilities, pServiceProvider, m_SfExpHeapAllocator.GetBase()),
      m_AdminStaticService(g_AdminCapabilities, pServiceProvider, m_SfExpHeapAllocator.GetBase()),
      m_SystemStaticService(g_SystemCapabilities, pServiceProvider, m_SfExpHeapAllocator.GetBase()),
      m_RepairStaticService(g_RepairCapabilities, pServiceProvider, m_SfExpHeapAllocator.GetBase())
{
    // サービス名の登録とポートの初期化
    RegisterObjectForPort(m_UserStaticService.GetShared(), 22, UserServiceName);    // 10以上のプロセスで利用.その他アプリケーション/アプレット多重起動も考慮し余裕をもって用意.
    RegisterObjectForPort(m_AdminStaticService.GetShared(), 4, AdminServiceName);   // 本体設定、DevMenu、DevMenuComannd、テスト用など. 4 で十分.
    RegisterObjectForPort(m_SystemStaticService.GetShared(), 4, SystemServiceName); // ネットワーク時計を補正するnimとテスト用の2本は必須
    RegisterObjectForPort(m_RepairStaticService.GetShared(), 2, RepairServiceName); // 余裕を持って2本.

    // サーバマネージャの開始
    // ただし、実際のサーバ動作は、LoopAuto 関数等を呼び出すことで行う必要がある
    Start();
}

HipcServerManager::~HipcServerManager() NN_NOEXCEPT
{
}

#endif

}
}
}
}
