﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/timesrv/detail/core/timesrv_TickBasedSteadyClockCore.h>

#include <nn/time/detail/time_CommonDetail.h>
#include <nn/os.h>
#include <nn/util/util_UuidApi.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

TickBasedSteadyClockCore::TickBasedSteadyClockCore() NN_NOEXCEPT:
    m_SourceId(nn::util::GenerateUuid())
{
}

TickBasedSteadyClockCore::~TickBasedSteadyClockCore() NN_NOEXCEPT
{
}

Result TickBasedSteadyClockCore::GetCurrentTimePointImpl(nn::time::SteadyClockTimePoint* pSteadyClockTimePoint) const NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pSteadyClockTimePoint);

    pSteadyClockTimePoint->value = nn::os::GetSystemTick().ToTimeSpan().GetSeconds();
    pSteadyClockTimePoint->sourceId = m_SourceId;

    NN_RESULT_SUCCESS;
}

}
}
}
}

