﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/timesrv/detail/core/timesrv_SteadyClockCore.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

using ::nn::time::SteadyClockTimePoint;

SteadyClockCore::SteadyClockCore() NN_NOEXCEPT:
    m_IsRtcResetDetected(false)
{
}

SteadyClockCore::~SteadyClockCore() NN_NOEXCEPT
{
}

Result SteadyClockCore::GetCurrentTimePoint(SteadyClockTimePoint* pOutSteadyClockTimePoint) const NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutSteadyClockTimePoint);

    NN_RESULT_DO(GetCurrentTimePointImpl(pOutSteadyClockTimePoint));

    *pOutSteadyClockTimePoint += GetTestOffset();
    *pOutSteadyClockTimePoint += GetInternalOffset();

    NN_RESULT_SUCCESS;
}

nn::TimeSpan SteadyClockCore::GetCurrentTimePointValue() const NN_NOEXCEPT
{
    auto value = GetCurrentTimePointValueImpl();
    value += GetTestOffset();
    value += GetInternalOffset();

    return value;
}

nn::TimeSpan SteadyClockCore::GetTestOffset() const NN_NOEXCEPT
{
    return GetTestOffsetImpl();
}

void SteadyClockCore::SetTestOffset(const nn::TimeSpan& testOffset) NN_NOEXCEPT
{
    SetTestOffsetImpl(testOffset);
}

void SteadyClockCore::SetInternalOffset(const nn::TimeSpan& internalOffset) NN_NOEXCEPT
{
    SetInternalOffsetImpl(internalOffset);
}

nn::TimeSpan SteadyClockCore::GetInternalOffset() const NN_NOEXCEPT
{
    return GetInternalOffsetImpl();
}

Result SteadyClockCore::GetRtcSeconds(int64_t* pOutValue) NN_NOEXCEPT
{
    return GetRtcSecondsImpl(pOutValue);
}

bool SteadyClockCore::IsRtcResetDetected() const NN_NOEXCEPT
{
    return m_IsRtcResetDetected;
}

void SteadyClockCore::DetectRtcReset() NN_NOEXCEPT
{
    m_IsRtcResetDetected = true;
}

nn::TimeSpan SteadyClockCore::GetCurrentTimePointValueImpl() const NN_NOEXCEPT
{
    SteadyClockTimePoint tp;
    NN_ABORT_UNLESS_RESULT_SUCCESS(GetCurrentTimePointImpl(&tp));

    return nn::TimeSpan::FromSeconds(tp.value);
}

nn::TimeSpan SteadyClockCore::GetTestOffsetImpl() const NN_NOEXCEPT
{
    return nn::TimeSpan(0);
}

void SteadyClockCore::SetTestOffsetImpl(const nn::TimeSpan& testOffset) NN_NOEXCEPT
{
    NN_UNUSED(testOffset);
}

nn::TimeSpan SteadyClockCore::GetInternalOffsetImpl() const NN_NOEXCEPT
{
    return nn::TimeSpan(0);
}

void SteadyClockCore::SetInternalOffsetImpl(const nn::TimeSpan& internalOffset) NN_NOEXCEPT
{
    NN_UNUSED(internalOffset);
}

Result SteadyClockCore::GetRtcSecondsImpl(int64_t* pOutValue) NN_NOEXCEPT
{
    NN_UNUSED(pOutValue);
    NN_RESULT_THROW(nn::time::ResultNotImplemented());
}

}
}
}
}

