﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/detail/time_CommonDetail.h>
#include <nn/timesrv/detail/core/timesrv_PscHandler-spec.nx.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

namespace
{
    PmStateChangeCallback* g_pPmStateChangeCallback = nullptr;
}


Result InitializePmModule(nn::psc::PmModule* pPmModule, PmStateChangeCallback* pPmStateChangeCallback) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pPmModule);

    g_pPmStateChangeCallback = pPmStateChangeCallback;

    auto result = pPmModule->Initialize(
            nn::psc::PmModuleId_Time,
            nullptr,
            0,
            nn::os::EventClearMode_ManualClear);
    NN_SDK_ASSERT(result.IsSuccess(), "[TIMESRV] nn::psd::PmModule::Initialize() failed. (%08x, %03d-%04d)",
            result.GetInnerValueForDebug(),
            result.GetModule(), result.GetDescription());

    NN_RESULT_THROW(result);
}

void HandlePmModule(nn::psc::PmModule* pPmModule) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pPmModule);

    nn::psc::PmState    state;
    nn::psc::PmFlagSet  flags;

    NN_DETAIL_TIME_ASSERT_IF_RESULT_FAILURE( pPmModule->GetRequest(&state, &flags) );

    //NN_DETAIL_TIME_INFO("[TIMRSRV] pm state %d\n", state);

    if(g_pPmStateChangeCallback)
    {
        switch(state)
        {
        case nn::psc::PmState_FullAwake:
            {
                g_pPmStateChangeCallback->FullAwakeCallback();
            }
            break;
        case nn::psc::PmState_MinimumAwake:
            {
                g_pPmStateChangeCallback->MinimumAwakeCallback();
            }
            break;
        case nn::psc::PmState_SleepReady:
            {
                g_pPmStateChangeCallback->SleepReadyCallback();
            }
            break;
        case nn::psc::PmState_ShutdownReady:
            {
                g_pPmStateChangeCallback->ShutdownReadyCallback();
            }
            break;
        default:
            break;
        }
    }


    NN_DETAIL_TIME_ASSERT_IF_RESULT_FAILURE( pPmModule->Acknowledge(state, nn::ResultSuccess()) );
}

void FinalizePmModule(nn::psc::PmModule* pPmModule) NN_NOEXCEPT
{
    NN_DETAIL_TIME_ASSERT_IF_RESULT_FAILURE( pPmModule->Finalize() );
}

}
}
}
}

