﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/time_StandardUserSystemClockPrivilegeApi.h>

#include <nn/time/detail/time_CommonDetail.h>
#include <nn/time/detail/time_SharedMemoryClient.h>
#include <nn/timesrv/detail/service/timesrv_IStaticService.sfdl.h>

#include <nn/util/util_Optional.h>

namespace nn
{
namespace time
{

extern nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService> g_pStaticService;
extern nn::util::optional<nn::time::detail::SharedMemoryClient> g_SharedMemoryClient;

// Admin権限がないと成功しない特権API
void SetStandardUserSystemClockAutomaticCorrectionEnabled(bool value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_pStaticService != nullptr, "[TIME] The time library is not initialized.");
    NN_ABORT_UNLESS_RESULT_SUCCESS( g_pStaticService->SetStandardUserSystemClockAutomaticCorrectionEnabled(value) );
}

bool IsStandardUserSystemClockAutomaticCorrectionEnabled() NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_SharedMemoryClient == true, "[TIME] The time library is not initialized.");

    return g_SharedMemoryClient->IsStandardUserSystemClockAutomaticCorrectionEnabled();
}

}
}

