﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/time_ApiForClockSnapshot.h>
#include <nn/time/detail/time_ClockSnapshotPrivateApi.h>
#include <nn/timesrv/detail/service/timesrv_IStaticService.sfdl.h>

namespace nn { namespace time {

extern nn::sf::SharedPointer<nn::timesrv::detail::service::IStaticService> g_pStaticService;

nn::TimeSpan CalculateStandardUserSystemClockDifferenceByUser(
    const ClockSnapshot& from,
    const ClockSnapshot& to) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_pStaticService != nullptr, "[TIME] The time library is not initialized.");

    auto pFrom = nn::time::detail::GetSfClockSnapshotPtr(&from);
    auto pTo = nn::time::detail::GetSfClockSnapshotPtr(&to);

    NN_SDK_REQUIRES(pFrom->initialType == pTo->initialType, "[TIME] The initial types of two ClockSnapshot are not matched.");

    nn::TimeSpanType differenceByUser;
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_pStaticService->CalculateStandardUserSystemClockDifferenceByUser(&differenceByUser, *pFrom, *pTo));

    return nn::TimeSpan(differenceByUser);
}

bool CalculateSpanBetween(
    nn::TimeSpan* pOut,
    const ClockSnapshot& from,
    const ClockSnapshot& to) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_pStaticService != nullptr, "[TIME] The time library is not initialized.");
    NN_SDK_REQUIRES_NOT_NULL(pOut);

    auto pFrom = nn::time::detail::GetSfClockSnapshotPtr(&from);
    auto pTo = nn::time::detail::GetSfClockSnapshotPtr(&to);

    nn::TimeSpanType span;
    auto result = g_pStaticService->CalculateSpanBetween(&span, *pFrom, *pTo);
    if(result.IsSuccess())
    {
        *pOut = span;
        return true;
    }

    return false;
}

}}

