﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/time/detail/time_ClockSnapshotPrivateApi.h>
#include <nn/util/util_UuidTypes.h>

namespace nn { namespace time { namespace detail {

nn::time::sf::ClockSnapshot* GetSfClockSnapshotPtr(ClockSnapshot* p) NN_NOEXCEPT
{
    return reinterpret_cast<nn::time::sf::ClockSnapshot*>(p);
}

const nn::time::sf::ClockSnapshot* GetSfClockSnapshotPtr(const ClockSnapshot* p) NN_NOEXCEPT
{
    return reinterpret_cast<const nn::time::sf::ClockSnapshot*>(p);
}

ClockSnapshotInitialType GetClockSnapshotInitialType(const ClockSnapshot& snapshot) NN_NOEXCEPT
{
    auto p = GetSfClockSnapshotPtr(&snapshot);
    return static_cast<ClockSnapshotInitialType>(p->initialType);
}

bool IsClockSnapshotAutomaticCorrectionEnabled(const ClockSnapshot& snapshot) NN_NOEXCEPT
{
    auto p = GetSfClockSnapshotPtr(&snapshot);
    return p->isAutomaticCorrectionEnabled;
}

}}}
