﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <mutex>

#include <nn/nn_Common.h>
#include <nn/os.h>

#include <nn/stdfu/stdfu.h>
#include <nn/stdfu/stdfu_DfuUpdateStatus.h>

namespace nn {
namespace stdfu {
//////////////////////////////////////////////////////////////////////////////
// Public
//////////////////////////////////////////////////////////////////////////////
DfuUpdateStatus::DfuUpdateStatus() NN_NOEXCEPT
    : m_Mutex(true)
{
}


//////////////////////////////////////////////////////////////////////////////
DfuUpdateStatus::~DfuUpdateStatus() NN_NOEXCEPT
{
}


//////////////////////////////////////////////////////////////////////////////
void DfuUpdateStatus::Initialize() NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_Mutex);
    m_UpdateStatus.phase    = UpdatePhase::UpdatePhase_None;
    m_UpdateStatus.image    = 0;
    m_UpdateStatus.element  = 0;
    m_UpdateStatus.progress = 0;
}


//////////////////////////////////////////////////////////////////////////////
void DfuUpdateStatus::Finalize() NN_NOEXCEPT
{
    Initialize();
}


//////////////////////////////////////////////////////////////////////////////
void DfuUpdateStatus::SetPhase(uint32_t phase) NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_Mutex);
    m_UpdateStatus.phase = phase;
}


//////////////////////////////////////////////////////////////////////////////
void DfuUpdateStatus::SetImage(uint32_t image)  NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_Mutex);
    m_UpdateStatus.image = image;
}


//////////////////////////////////////////////////////////////////////////////
void DfuUpdateStatus::SetElement(uint32_t element)  NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_Mutex);
    m_UpdateStatus.element = element;
}


//////////////////////////////////////////////////////////////////////////////
void DfuUpdateStatus::SetProgress(uint32_t progress)  NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_Mutex);
    m_UpdateStatus.progress = progress;
}


//////////////////////////////////////////////////////////////////////////////
void DfuUpdateStatus::GetUpdateStatus(UpdateStatus *pUpdateStatus) NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_Mutex);
    memcpy(pUpdateStatus, &m_UpdateStatus, sizeof(UpdateStatus));
}

//////////////////////////////////////////////////////////////////////////////
} // namespace stdfu
} // namespace nn

