﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.ssl.sf
{
    [CppRefPath(@"<nn/ssl/detail/ssl_ISslConnection.h>")]
    public struct PollEvent
    {
        public uint32_t events;
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslConnection.h>")]
    public struct VerifyOption
    {
        public uint32_t options;
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslConnection.h>")]
    public struct IoMode
    {
        public uint32_t mode;
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslConnection.h>")]
    public struct SessionCacheMode
    {
        public uint32_t mode;
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslConnection.h>")]
    public struct RenegotiationMode
    {
        public uint32_t mode;
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslConnection.h>")]
    public struct OptionType
    {
        public uint32_t type;
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslConnection.h>")]
    public interface ISslConnection : IServiceObject
    {
        [MethodId(0)]
        Result SetSocketDescriptor(int socket, Out<int> socketToClock);

        [MethodId(1)]
        Result SetHostName(InBuffer hostName);

        [MethodId(2)]
        Result SetVerifyOption(VerifyOption optionValue);

        [MethodId(3)]
        Result SetIoMode(IoMode mode);

        [MethodId(4)]
        Result GetSocketDescriptor(Out<int> outValue);

        [MethodId(5)]
        Result GetHostName(OutBuffer hostNameBuffer, Out<uint32_t> outHostNameLength);

        [MethodId(6)]
        Result GetVerifyOption(Out<VerifyOption> outVerifyOption);

        [MethodId(7)]
        Result GetIoMode(Out<IoMode> outIoMode);

        [MethodId(8)]
        Result DoHandshake();

        [MethodId(9)]
        Result DoHandshakeGetServerCert(Out<uint32_t> outServerCertSize, Out<uint32_t> outServerCertCount, OutBuffer outServerCert);

        [MethodId(10)]
        Result Read(Out<uint32_t> bytesRead, OutBuffer buffer);

        [MethodId(11)]
        Result Write(Out<uint32_t> bytesWritten, InBuffer buffer);

        [MethodId(12)]
        Result Pending(Out<int> byteCount);

        [MethodId(13)]
        Result Peek(Out<uint32_t> byteCount, OutBuffer buffer);

        [MethodId(14)]
        Result Poll(Out<PollEvent> outEvent, PollEvent inEvent, uint32_t msecTimeout);

        [MethodId(15)]
        Result GetVerifyCertError();

        [MethodId(16)]
        Result GetNeededServerCertBufferSize(Out<uint32_t> outNeededSize);

        [MethodId(17)]
        Result SetSessionCacheMode(SessionCacheMode mode);

        [MethodId(18)]
        Result GetSessionCacheMode(Out<SessionCacheMode> outSessionCachemode);

        [MethodId(19)]
        Result FlushSessionCache();

        [MethodId(20)]
        Result SetRenegotiationMode(RenegotiationMode mode);

        [MethodId(21)]
        Result GetRenegotiationMode(Out<RenegotiationMode> outRenegotiationMode);

        [MethodId(22)]
        Result SetOption(OptionType optionType, bool enable);

        [MethodId(23)]
        Result GetOption(Out<bool> outIsEnabled, OptionType optionType);

        [MethodId(24)]
        Result GetVerifyCertErrors(OutBuffer outResultArray, Out<uint32_t> outResultCountWritten, Out<uint32_t> outTotalResultCount);

        [MethodId(25)]
        Result GetCipherInfo(uint32_t structureVersion, OutBuffer outCipherInfo);
    }


    [CppRefPath(@"<nn/ssl/detail/ssl_ISslContext.h>")]
    public struct CertificateFormat
    {
        public uint32_t value;
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslContext.h>")]
    public struct ContextOption
    {
        public uint32_t name;
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslContext.h>")]
    public struct SslVersion
    {
        public int32_t flags;
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslContext.h>")]
    public struct InternalPki
    {
        public int32_t pki;
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslContext.h>")]
    public interface ISslContext : IServiceObject
    {
        [MethodId(0)]
        Result SetOption(ContextOption option, int32_t value);

        [MethodId(1)]
        Result GetOption(Out<int32_t> outValue, ContextOption option);

        [MethodId(2)]
        Result CreateConnection(Out<ISslConnection> outValue);

        [MethodId(3)]
        Result GetConnectionCount(Out<uint32_t> outValue);

        [MethodId(4)]
        Result ImportServerPki(Out<uint64_t> outCertId, InBuffer inCertData, CertificateFormat format);

        [MethodId(5)]
        Result ImportClientPki(Out<uint64_t> outCertId, InBuffer inP12Data, InBuffer inPwData);

        [MethodId(6)]
        Result RemoveServerPki(uint64_t certId);

        [MethodId(7)]
        Result RemoveClientPki(uint64_t certId);

        [MethodId(8)]
        Result RegisterInternalPki(Out<uint64_t> outCertId, InternalPki pkiType);

        [MethodId(9)]
        Result AddPolicyOid(InBuffer stringBuffer);

        [MethodId(10)]
        Result ImportCrl(Out<uint64_t> outCrlId, InBuffer inCrlDerData);

        [MethodId(11)]
        Result RemoveCrl(uint64_t crlId);
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslService.h>")]
    public struct FlushSessionCacheOptionType
    {
        public uint32_t option;
    }

    [CppRefPath(@"<nn/ssl/detail/ssl_ISslService.h>")]
    public interface ISslService : IServiceObject
    {
        [MethodId(0)]
        Result CreateContext(Out<ISslContext> outValue, SslVersion version, [ProcessId] nn.Bit64 pid);

        [MethodId(1)]
        Result GetContextCount(Out<uint32_t> outValue);

        [MethodId(2)]
        Result GetCertificates(OutBuffer outCertsData, Out<uint32_t> outIdCount, InBuffer inCertIds);

        [MethodId(3)]
        Result GetCertificateBufSize(Out<uint32_t> outSize, InBuffer inCertIds);

        [MethodId(4)]
        Result DebugIoctl(OutBuffer outBufferInfo, InBuffer inBufferInfo, uint64_t cmd);

        [MethodId(5)]
        Result SetInterfaceVersion(uint32_t inValue);

        [MethodId(6)]
        Result FlushSessionCache(Out<uint32_t> outEntriesDeletedCount, InBuffer pInHostNameBuf, FlushSessionCacheOptionType optionValue);
    }

}
