﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/ssl/detail/ssl_Build.h>
#include <nn/ssl/ssl_Types.h>

namespace nn { namespace ssl { namespace detail {

class SslMemoryManager
{
private:
    static nn::lmem::HeapHandle                         g_Heap;
    static nn::sf::ExpHeapAllocator                     g_SfAllocator;
    static size_t                                       g_HeapStartFreeSize;
    static char*                                        g_pHeapHead;
    static size_t                                       g_HeapSize;

public:
    static Result Initialize(char* pBuffer, size_t bufferSize);
    static Result Finalize();

    static void* AllocateChunk(size_t sizeInByte, uint64_t id);
    static Result Free(void* pMemoryAddress, uint64_t id);

    static nn::sf::ExpHeapAllocator *GetSfAllocator();
};

}}}
