﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>

#include "detail/ssl_ServiceSession.h"
#include "detail/ssl_ISslServiceFactory.h"
#include "server/ssl_Util.h"


namespace nn { namespace ssl { namespace detail {

SharedPointer<ISslService>      ServiceSession::g_ServiceSession = nullptr;


nn::Result ServiceSession::Initialize(uint32_t numSessions)
{
    nn::Result                  ret = ResultSuccess();

    do
    {
        if ((g_ServiceSession == nullptr) || (g_ServiceSession.Get() == nullptr))
        {
            if ((numSessions == 0) || (numSessions > g_MaxSessions))
            {
                NN_DETAIL_SSL_WARN_PRINT("Initialize: invalid sessions requested: %d\n", numSessions);
                ret = ResultInvalidConcurrencyLimit();
                break;
            }

            //  Init the SSL interface factory
            ret = ISslServiceFactory::Initialize(numSessions);
            if (ret.IsFailure())
            {
                break;
            }

            ISslServiceFactory      factory;
            ret = factory.CreateISslService(&g_ServiceSession);
            if (ret.IsFailure())
            {
                break;
            }

            // Set the version of ISslService, added after 3.0.0 NUP
            ret = g_ServiceSession->SetInterfaceVersion(ISslServiceFactory::ISslServiceVersion);
        }
        else
        {
            ret = ResultLibraryAlreadyInitialized();
            break;
        }
    } while (NN_STATIC_CONDITION(false));

    return ret;
}


void ServiceSession::Finalize()
{
    g_ServiceSession = nullptr;
    ISslServiceFactory::Finalize();
}


bool ServiceSession::IsInitialized()
{
    bool                        ret = false;

    if (g_ServiceSession != nullptr)
    {
        ret = true;
    }

    return ret;
}


SharedPointer<ISslService> *ServiceSession::GetServiceSession()
{
    return &g_ServiceSession;
}

} } }
