﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/ssl/detail/ssl_Build.h>
#include <nn/ssl/detail/ssl_Common.h>

#include "../server/ssl_NssCommon.h"

#include "sslimpl.h"
#include "sslproto.h"
#include "nssilock.h"

#include "ssl_DebugUtil.h"
#include "ssl_DebugSessionCache.h"

#ifndef NN_DETAIL_SSL_ENABLE_PROCESS_DEBUG
#error 'This file must not be used unless the debug flag is defined'
#endif

// ------------------------------------------------------------------------------------------------
// External/nss/lib/ssl/sslnonce.c
// ------------------------------------------------------------------------------------------------
extern sslSessionID* SSL_GetSessionCacheList();
extern void SSL_UncacheSID(sslSessionID *sid);
extern void SSL_ObtainSessionCacheLock();
extern void SSL_ReleaseSessionCacheLock();

namespace nn { namespace ssl { namespace detail {

// ------------------------------------------------------------------------------------------------
// DebugSessionCache
// ------------------------------------------------------------------------------------------------
DebugSessionCache::DebugSessionCache() :
    m_IsDumpStats(true),
    m_pDebugUtilObj(nullptr)
{
}

DebugSessionCache::~DebugSessionCache()
{
}

void DebugSessionCache::Initialize(DebugUtil* pInUtilObj)
{
    m_pDebugUtilObj = pInUtilObj;
}

void DebugSessionCache::Finalize()
{
    m_pDebugUtilObj = nullptr;
}

void DebugSessionCache::ConfigurePeriodicDump(bool enable)
{
    m_IsDumpStats = enable;
}

void DebugSessionCache::Dump()
{
    int           sidCount = 0;
    sslSessionID* pCurrSid = nullptr;

    nnsdkNssPortLockSessionCache();

    pCurrSid = reinterpret_cast<sslSessionID*>(nnsdkNssPortGetSessionCacheList());
    while (pCurrSid != nullptr)
    {
        NN_DETAIL_SSL_DBG_UTIL_PRINT("[SSL] Session cache - [%00d]:%s\n", sidCount, pCurrSid->peerID);
        sidCount++;
        pCurrSid = pCurrSid->next;
    }

    nnsdkNssPortUnlockSessionCache();
}

void DebugSessionCache::RunScheduler()
{
    nn::os::Tick curTick = nn::os::GetSystemTick();
    uint64_t elapsedMsec = 0;

    if (m_IsDumpStats)
    {
        elapsedMsec = nn::os::ConvertToTimeSpan(curTick - m_lastDumpTick).GetMilliSeconds();
        if (elapsedMsec > DumpMsecInterval)
        {
            m_pDebugUtilObj->GetWorker()->AddTask(DebugUtil::TaskType_DumpSessionCache);
            m_lastDumpTick = curTick;
        }
    }
}

}}} // namespace nn { namespace ssl { namespace detail {
