﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os.h>
#include <nn/dd.h>
#include <nn/svc/svc_Tcb.h>
#include <nn/spsm/detail/spsm_Log.h>
#include "spsm_Debug.h"
#include "spsm_EventLog.h"

namespace nn { namespace spsm { namespace server {

    void EnterSc7()
    {
        NN_DETAIL_SPSM_INFO("Trigger SystemSuspend SVC\n");

        //
        // Enter SC7
        //
        LogSc7Entry();
        nn::svc::SleepSystem();
        LogSc7Exit();
    }

}}}
