﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/os.h>
#include "spsm_PmControl.h"

namespace nn { namespace spsm { namespace server {

namespace {

    nn::os::Mutex g_Mutex(false);

}

nn::psc::PmControl* GetPmControl() NN_NOEXCEPT
{
    std::lock_guard<decltype(g_Mutex)> lock(g_Mutex);

    static nn::psc::PmControl s_PmControl;
    static bool               s_IsPmControlInitialized = false;

    // 初回のみ PSC のコントロールオブジェクトを初期化
    if (!s_IsPmControlInitialized)
    {
        NN_RESULT_DO(s_PmControl.Initialize(nn::os::EventClearMode_AutoClear));
        s_IsPmControlInitialized = true; // ステートマシン内でしか呼ばないのでスレッドアンセーフでよい
    }

    return &s_PmControl;
}

}}}

