﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/psc/psc_PmControl.h>
#include <nn/spsm/spsm_Debug.h>
#include "spsm_PerformanceLog.h"

namespace nn { namespace spsm { namespace server {

    void LogPscPerformance(nn::psc::PmControl* pPmControl) NN_NOEXCEPT;

    void ResetPerformanceLog() NN_NOEXCEPT;

    void AnalyzePerformanceLogForLastSleepWakeSequence(SleepWakeSequencePerformanceData* pOutData) NN_NOEXCEPT;

}}}
