﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Common.h>
#include <nn/os.h>
#include "spsm_PowerButton.h"
#include "spsm_AutoPowerDown.h"
#include "spsm_ThermalCoordinator.h"
#include "spsm_ThermalCoordinatorAdvancedPolicy.h"
#include "spsm_LowBattery.h"
#include "spsm_CecSystemStandby.h"
#include "spsm_BackgroundTask.h"
#include "spsm_HomeButton.h"
#include "spsm_InternalTimer.h"
#include "spsm_StorageDetection.h"
#include "spsm_DebugPowerStateMessageSender.h"

namespace nn { namespace spsm { namespace observer {

    class EventHandlerManager
    {
        NN_DISALLOW_COPY(EventHandlerManager);
        NN_DISALLOW_MOVE(EventHandlerManager);

    private: // Singleton
        EventHandlerManager() NN_NOEXCEPT;

    public:
        static EventHandlerManager& GetInstance() NN_NOEXCEPT
        {
            static EventHandlerManager inst;
            return inst;
        }

        void EventHandlerLoopAutoImpl(nn::os::SystemEventType*) NN_NOEXCEPT;
#if defined(NN_BUILD_CONFIG_OS_WIN)
        void StopEventHandlerLoopAutoImpl() NN_NOEXCEPT;
#endif

        // HOME ボタンのパラメータ制御
        void ChangeHomeButtonLongPressingTime(TimeSpan timeLongPressing) NN_NOEXCEPT
        {
            m_HomeButton.ChangeLongPressingTime(timeLongPressing);
        }

    private:
        PowerButton m_PowerButton;
        AutoPowerDown m_AutoSleepRequest;
        ThermalCoordinator m_ThermalCoordinator;
        ThermalCoordinatorAdvancedPolicy m_ThermalCoordinatorAdvancedPolicy;
        LowBattery m_LowBattery;
        CecSystemStandby m_CecSystemStandby;
        BackgroundTask m_BackgroundTask;
        HomeButton m_HomeButton;
        InternalTimer m_InternalTimer;
        StorageDetection m_StorageDetection;
        DebugPowerStateMessageSender m_DebugPowerStateMessageSender;

#if defined(NN_BUILD_CONFIG_OS_WIN)
        nn::os::EventType m_StopEvent;
#endif
    };

}}} // namespace nn::spsm::observer

