﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/settings/settings_Xpad.h>

#include "detail/settings_XpadImpl.h"

namespace nn { namespace settings {

void GetXpadGenericPadMap(BasicXpadGenericPadMap* outValue, int playerNumber
                          ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetXpadGenericPadMap(outValue, playerNumber));
}

void SetXpadGenericPadMap(const BasicXpadGenericPadMap& value, int playerNumber
                          ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::SetXpadGenericPadMap(value, playerNumber));
}

void ResetXpadGenericPadMap(int playerNumber) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::ResetXpadGenericPadMap(playerNumber));
}

void GetXpadKeyboardMap(BasicXpadKeyboardMap* outValue, int playerNumber
                        ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetXpadKeyboardMap(outValue, playerNumber));
}

void SetXpadKeyboardMap(const BasicXpadKeyboardMap& value, int playerNumber
                        ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::SetXpadKeyboardMap(value, playerNumber));
}

void ResetXpadKeyboardMap(int playerNumber) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ResetXpadKeyboardMap(playerNumber));
}

}} // namespace nn::settings
