﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_SixAxisSensor.h>

#include "detail/settings_SixAxisSensorImpl.h"

namespace nn { namespace settings { namespace system {

void GetConsoleSixAxisSensorAccelerationBias(ConsoleSixAxisSensorAccelerationBias* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetConsoleSixAxisSensorAccelerationBias(pOutValue));
}

void SetConsoleSixAxisSensorAccelerationBias(const ConsoleSixAxisSensorAccelerationBias& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetConsoleSixAxisSensorAccelerationBias(value));
}

void GetConsoleSixAxisSensorAngularVelocityBias(ConsoleSixAxisSensorAngularVelocityBias* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetConsoleSixAxisSensorAngularVelocityBias(pOutValue));
}

void SetConsoleSixAxisSensorAngularVelocityBias(const ConsoleSixAxisSensorAngularVelocityBias& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetConsoleSixAxisSensorAngularVelocityBias(value));
}

void GetConsoleSixAxisSensorAccelerationGain(
    ConsoleSixAxisSensorAccelerationGain* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetConsoleSixAxisSensorAccelerationGain(pOutValue));
}

void SetConsoleSixAxisSensorAccelerationGain(
    const ConsoleSixAxisSensorAccelerationGain& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetConsoleSixAxisSensorAccelerationGain(value));
}

void GetConsoleSixAxisSensorAngularVelocityGain(
    ConsoleSixAxisSensorAngularVelocityGain* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetConsoleSixAxisSensorAngularVelocityGain(pOutValue));
}

void SetConsoleSixAxisSensorAngularVelocityGain(
    const ConsoleSixAxisSensorAngularVelocityGain& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetConsoleSixAxisSensorAngularVelocityGain(value));
}

void GetConsoleSixAxisSensorAngularVelocityTimeBias(
    ConsoleSixAxisSensorAngularVelocityTimeBias* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetConsoleSixAxisSensorAngularVelocityTimeBias(pOutValue));
}

void SetConsoleSixAxisSensorAngularVelocityTimeBias(
    const ConsoleSixAxisSensorAngularVelocityTimeBias& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetConsoleSixAxisSensorAngularVelocityTimeBias(value));
}

void GetConsoleSixAxisSensorAngularAcceleration(
    ConsoleSixAxisSensorAngularAcceleration* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetConsoleSixAxisSensorAngularAcceleration(pOutValue));
}

void SetConsoleSixAxisSensorAngularAcceleration(
    const ConsoleSixAxisSensorAngularAcceleration& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetConsoleSixAxisSensorAngularAcceleration(value));
}

}}} // namespace nn::settings::system
