﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/settings/system/settings_OnlineStorage.h>

#include "detail/settings_OnlineStorageImpl.h"

namespace nn { namespace settings { namespace system {

int GetAccountOnlineStorageSettings(
    AccountOnlineStorageSettings outValues[], int count) NN_NOEXCEPT
{
    auto outCount = int32_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetAccountOnlineStorageSettings(
            &outCount, outValues, static_cast<size_t>(::std::max(0, count))));
    return outCount;
}

void SetAccountOnlineStorageSettings(
    const AccountOnlineStorageSettings values[], int count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetAccountOnlineStorageSettings(
            values, static_cast<size_t>(::std::max(0, count))));
}

}}} // namespace nn::settings::system
