﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/settings/system/settings_Fatal.h>

#include "detail/settings_FatalImpl.h"

namespace nn { namespace settings { namespace system {

void BindFatalDirtyFlagEvent(
    ::nn::os::SystemEventType* pEvent,
    ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::BindFatalDirtyFlagEvent(pEvent, clearMode));
}

void GetFatalDirtyFlags(FatalDirtyFlagSet* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetFatalDirtyFlags(pOutValue));
}

}}} // namespace nn::settings::system
