﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/system/settings_Web.h>

namespace nn { namespace settings { namespace detail {

::nn::Result GetWebInspectorFlag(bool* pOutValue) NN_NOEXCEPT;

::nn::Result SetWebInspectorFlag(bool value) NN_NOEXCEPT;

::nn::Result GetAllowedSslHosts(
    int32_t* pOutCount,
    ::nn::settings::system::AllowedSslHost outHosts[],
    size_t count) NN_NOEXCEPT;

::nn::Result SetAllowedSslHosts(
    const ::nn::settings::system::AllowedSslHost values[],
    size_t count) NN_NOEXCEPT;

::nn::Result GetHostFsMountPoint(
    ::nn::settings::system::HostFsMountPoint* pOutValue) NN_NOEXCEPT;

::nn::Result SetHostFsMountPoint(
    const ::nn::settings::system::HostFsMountPoint& value) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
