﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/nn_BuildRevision.h>
#include <nn/nn_FirmwareVersion.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ResultPrivate.h>
#include <nn/settings/system/settings_FirmwareVersion.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_StringUtil.h>

#include "settings_SystemVersionDatabase.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetSystemVersionFirmwareVersion(
    ::nn::settings::system::FirmwareVersion* pOutValue, int port) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(
        pOutValue != nullptr, ResultNullFirmwareVersionBuffer());

    ::nn::settings::system::FirmwareVersion& value = *pOutValue;

    ::std::memset(&value, 0, sizeof(value));

    value.major = NN_FIRMWARE_VERSION_MAJOR;
    value.minor = NN_FIRMWARE_VERSION_MINOR;
    value.micro = NN_FIRMWARE_VERSION_MICRO;
    value.majorRelstep = NN_FIRMWARE_VERSION_MAJORRELSTEP;
    value.minorRelstep = NN_FIRMWARE_VERSION_MINORRELSTEP;

    ::nn::util::Strlcpy(
        value.revision, NN_BUILD_REVISION_HASH_STRING_FULL, sizeof(value.revision));

    ::nn::util::Strlcpy(
        value.platform,
#ifdef NN_BUILD_CONFIG_SPEC_GENERIC
        "Generic",
#elif NN_BUILD_CONFIG_SPEC_NX
        "NX",
#else
        "Unknown",
#endif
        sizeof(value.platform));

    ::nn::util::SNPrintf(
        value.displayVersion, sizeof(value.displayVersion),
        "%d.%d.%d", value.major, value.minor, value.micro);

    ::nn::util::SNPrintf(
        value.displayName, sizeof(value.displayName),
        "NintendoSDK Firmware for %s %s-%d.%d",
        value.platform,
        value.displayVersion, value.majorRelstep, value.minorRelstep);

    if (port == 1)
    {
        // 旧仕様とのバイナリ互換性を維持
        value.minorRelstep = 0;
    }

    NN_RESULT_SUCCESS;
}

::nn::Result GetSystemVersionFirmwareVersionDigest(
    ::nn::settings::system::FirmwareVersionDigest* pOutValue) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(
        pOutValue != nullptr, ResultNullFirmwareVersionDigestBuffer());

    ::nn::settings::system::FirmwareVersionDigest& value = *pOutValue;

    ::std::memset(&value, 0, sizeof(value));

    ::nn::util::Strlcpy(
        value.data, NN_FIRMWARE_VERSION_DIGEST, sizeof(value.data));

    NN_RESULT_SUCCESS;
}

::nn::Result GetSystemRebootlessSystemUpdateVersion(
    ::nn::settings::system::RebootlessSystemUpdateVersion* pOutValue) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(
        pOutValue != nullptr, ResultNullRebootlessSystemUpdateVersionBuffer());

    ::nn::settings::system::RebootlessSystemUpdateVersion& value = *pOutValue;

    value.version = 0;
    ::nn::util::SNPrintf(value.displayVersion, sizeof(value.displayVersion), "0");

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
