﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/settings_Language.h>
#include <nn/settings/settings_ResultPrivate.h>
#include <nn/settings/settings_ServiceTypes.h>
#include <nn/settings/system/settings_Account.h>
#include <nn/settings/system/settings_Audio.h>
#include <nn/settings/system/settings_Backlight.h>
#include <nn/settings/system/settings_BatteryLot.h>
#include <nn/settings/system/settings_BluetoothDevices.h>
#include <nn/settings/system/settings_Clock.h>
#include <nn/settings/system/settings_DataDeletion.h>
#include <nn/settings/system/settings_Eula.h>
#include <nn/settings/system/settings_Fatal.h>
#include <nn/settings/system/settings_FirmwareVersion.h>
#include <nn/settings/system/settings_Mii.h>
#include <nn/settings/system/settings_Network.h>
#include <nn/settings/system/settings_News.h>
#include <nn/settings/system/settings_OnlineStorage.h>
#include <nn/settings/system/settings_Ptm.h>
#include <nn/settings/system/settings_Region.h>
#include <nn/settings/system/settings_SerialNumber.h>
#include <nn/settings/system/settings_ServiceDiscovery.h>
#include <nn/settings/system/settings_SixAxisSensor.h>
#include <nn/settings/system/settings_Sleep.h>
#include <nn/settings/system/settings_Telemetry.h>
#include <nn/settings/system/settings_TimeZone.h>
#include <nn/settings/system/settings_Tv.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_Out.h>
#include <nn/util/util_Uuid.h>

#include "settings_ApplicationSettingsDatabase.h"
#include "settings_CalibrationBinaryDatabase.h"
#include "settings_CalibrationFileDatabase.h"
#include "settings_DeviceSettingsDatabase.h"
#include "settings_FirmwareDebugSettingsDatabase.h"
#include "settings_StaticObject.h"
#include "settings_SystemSettingsDatabase.h"
#include "settings_SystemSettingsServer.h"
#include "settings_SystemVersionDatabase.h"

namespace nn { namespace settings { namespace detail {

SystemSettingsServer::SystemSettingsServer() NN_NOEXCEPT
{
    //何もしない
}

::nn::Result SystemSettingsServer::SetLanguageCode(
    ::nn::settings::LanguageCode value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsLanguageCode(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetNetworkSettings(
    ::nn::sf::InArray<nn::settings::system::NetworkSettings> values) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsNetworkSettings(
            values.GetData(), static_cast<int32_t>(values.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetNetworkSettings(
    ::nn::sf::Out<int32_t> outCount,
    ::nn::sf::OutArray<::nn::settings::system::NetworkSettings> outValues
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsNetworkSettings(
            outCount.GetPointer(),
            outValues.GetData(), static_cast<int32_t>(outValues.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetBluetoothDevicesSettings(
    const ::nn::sf::InArray<
        ::nn::settings::system::BluetoothDevicesSettings>& values) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsBluetoothDevicesSettings(
            values.GetData(), static_cast<int32_t>(values.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetBluetoothDevicesSettings(
    ::nn::sf::Out<int32_t> outCount,
    const ::nn::sf::OutArray<
        ::nn::settings::system::BluetoothDevicesSettings>& outValues
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsBluetoothDevicesSettings(
            outCount.GetPointer(),
            outValues.GetData(), static_cast<int32_t>(outValues.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetBluetoothEnableFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsBluetoothEnableFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetBluetoothEnableFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsBluetoothEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetFirmwareVersion(
    ::nn::sf::Out<::nn::settings::system::FirmwareVersion> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemVersionFirmwareVersion(outValue.GetPointer(), 1));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetFirmwareVersion2(
    ::nn::sf::Out<::nn::settings::system::FirmwareVersion> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemVersionFirmwareVersion(outValue.GetPointer(), 2));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetFirmwareVersionDigest(
    ::nn::sf::Out<::nn::settings::system::FirmwareVersionDigest> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemVersionFirmwareVersionDigest(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetLockScreenFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsLockScreenFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetLockScreenFlag(bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsLockScreenFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetBacklightSettings(
    ::nn::sf::Out<::nn::settings::system::BacklightSettings> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsBacklightSettings(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetBacklightSettings(
    const ::nn::settings::system::BacklightSettings& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsBacklightSettings(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetExternalSteadyClockSourceId(
    ::nn::sf::Out<::nn::settings::system::ClockSourceId> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsExternalSteadyClockSourceId(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetExternalSteadyClockSourceId(
    const ::nn::settings::system::ClockSourceId& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsExternalSteadyClockSourceId(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetShutdownRtcValue(
    ::nn::sf::Out<int64_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsShutdownRtcValue(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetShutdownRtcValue(
    int64_t value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsShutdownRtcValue(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetExternalSteadyClockInternalOffset(
    ::nn::sf::Out<int64_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsExternalSteadyClockInternalOffset(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetExternalSteadyClockInternalOffset(
    int64_t value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsExternalSteadyClockInternalOffset(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetUserSystemClockContext(
    ::nn::sf::Out<::nn::settings::system::SystemClockContext> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsUserSystemClockContext(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetUserSystemClockContext(
    const ::nn::settings::system::SystemClockContext& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsUserSystemClockContext(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetNetworkSystemClockContext(
    ::nn::sf::Out<::nn::settings::system::SystemClockContext> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsNetworkSystemClockContext(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetNetworkSystemClockContext(
    const ::nn::settings::system::SystemClockContext& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsNetworkSystemClockContext(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::IsUserSystemClockAutomaticCorrectionEnabled(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsUserSystemClockAutomaticCorrectionFlag(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetUserSystemClockAutomaticCorrectionEnabled(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsUserSystemClockAutomaticCorrectionFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetUserSystemClockAutomaticCorrectionUpdatedTime(
    ::nn::sf::Out<::nn::time::SteadyClockTimePoint> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsUserSystemClockAutomaticCorrectionUpdatedTime(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetUserSystemClockAutomaticCorrectionUpdatedTime(
    const ::nn::time::SteadyClockTimePoint& value) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsUserSystemClockAutomaticCorrectionUpdatedTime(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetAccountSettings(
    ::nn::sf::Out<::nn::settings::system::AccountSettings> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsAccountSettings(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetAccountSettings(
    const ::nn::settings::system::AccountSettings& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsAccountSettings(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetAudioVolume(
    ::nn::sf::Out<::nn::settings::system::AudioVolume> outValue,
    int32_t index) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsAudioVolume(outValue.GetPointer(), index));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetAudioVolume(
    const ::nn::settings::system::AudioVolume& value,
    int32_t index) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsAudioVolume(value, index));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetEulaVersions(
    ::nn::sf::Out<int32_t> outCount,
    ::nn::sf::OutArray<::nn::settings::system::EulaVersion> outValues
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsEulaVersions(
            outCount.GetPointer(), outValues.GetData(), outValues.GetLength()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetEulaVersions(
    ::nn::sf::InArray<::nn::settings::system::EulaVersion> values
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsEulaVersions(values.GetData(), values.GetLength()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetColorSetId(
    ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsColorSetId(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetColorSetId(int32_t value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsColorSetId(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetConsoleInformationUploadFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsConsoleInformationUploadFlag(
                     outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetConsoleInformationUploadFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsConsoleInformationUploadFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetAutomaticApplicationDownloadFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsAutomaticApplicationDownloadFlag(
                     outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetAutomaticApplicationDownloadFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsAutomaticApplicationDownloadFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetNotificationSettings(
    ::nn::sf::Out<::nn::settings::system::NotificationSettings> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsNotificationSettings(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetNotificationSettings(
    const ::nn::settings::system::NotificationSettings& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsNotificationSettings(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetAccountNotificationSettings(
    ::nn::sf::Out<int32_t> outCount,
    const ::nn::sf::OutArray<
        ::nn::settings::system::AccountNotificationSettings>& outValues
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsAccountNotificationSettings(
            outCount.GetPointer(),
            outValues.GetData(), static_cast<int32_t>(outValues.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetAccountNotificationSettings(
    const ::nn::sf::InArray<
        ::nn::settings::system::AccountNotificationSettings>& values
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsAccountNotificationSettings(
            values.GetData(), static_cast<int32_t>(values.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetVibrationMasterVolume(
    ::nn::sf::Out<float> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsVibrationMasterVolume(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetVibrationMasterVolume(
    float value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsVibrationMasterVolume(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetSettingsItemValueSize(
    ::nn::sf::Out<uint64_t> outValue,
    const SettingsName& name,
    const SettingsItemKey& key) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetFwdbgSettingsItemValueSize(outValue.GetPointer(), name, key));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetSettingsItemValue(
    ::nn::sf::Out<uint64_t> outValue,
    const ::nn::sf::OutBuffer& buffer,
    const SettingsName& name,
    const SettingsItemKey& key) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetFwdbgSettingsItemValue(outValue.GetPointer(),
                                  buffer.GetPointerUnsafe(),
                                  buffer.GetSize(),
                                  name, key));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetTvSettings(
    ::nn::sf::Out<::nn::settings::system::TvSettings> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsTvSettings(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetTvSettings(
    const ::nn::settings::system::TvSettings& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsTvSettings(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetEdid(
    ::nn::sf::Out<::nn::settings::system::Edid> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsEdid(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetEdid(
    const ::nn::settings::system::Edid& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsEdid(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetAudioOutputMode(
    ::nn::sf::Out<int32_t> outValue, int32_t index) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsAudioOutputMode(outValue.GetPointer(),
                                                  index));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetAudioOutputMode(
    int32_t value, int32_t index) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsAudioOutputMode(value, index));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::IsForceMuteOnHeadphoneRemoved(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsForceMuteOnHeadphoneRemovedFlag(
                     outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetForceMuteOnHeadphoneRemoved(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsForceMuteOnHeadphoneRemovedFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetQuestFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsQuestFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetQuestFlag(bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsQuestFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetDataDeletionSettings(
    ::nn::sf::Out<::nn::settings::system::DataDeletionSettings> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsDataDeletionSettings(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetDataDeletionSettings(
    ::nn::settings::system::DataDeletionSettings value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsDataDeletionSettings(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetInitialSystemAppletProgramId(
    ::nn::sf::Out<::nn::ncm::ProgramId> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsInitialSystemAppletProgramId(
                     outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetOverlayDispProgramId(
    ::nn::sf::Out<nn::ncm::ProgramId> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsOverlayDispProgramId(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetDeviceTimeZoneLocationName(
    ::nn::sf::Out<::nn::time::LocationName> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsDeviceTimeZoneLocationName(
                     outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetDeviceTimeZoneLocationName(
    const ::nn::time::LocationName& value
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsDeviceTimeZoneLocationName(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetDeviceTimeZoneLocationUpdatedTime(
    ::nn::sf::Out<::nn::time::SteadyClockTimePoint> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsDeviceTimeZoneLocationUpdatedTime(
                     outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetDeviceTimeZoneLocationUpdatedTime(
    const ::nn::time::SteadyClockTimePoint& value
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsDeviceTimeZoneLocationUpdatedTime(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetWirelessCertificationFileSize(
    ::nn::sf::Out<uint64_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetCalibFileWirelessCertificationFileSize(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetWirelessCertificationFile(
        ::nn::sf::Out<uint64_t> outValue,
        const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetCalibFileWirelessCertificationFile(outValue.GetPointer(),
                                              outBuffer.GetPointerUnsafe(),
                                              outBuffer.GetSize()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetRegionCode(int32_t value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsRegionCode(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetDebugModeFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetFwdbgDebugModeFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetPrimaryAlbumStorage(
    ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsPrimaryAlbumStorage(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetPrimaryAlbumStorage(
    int32_t value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsPrimaryAlbumStorage(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetUsb30EnableFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsUsb30EnableFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetUsb30EnableFlag(bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsUsb30EnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetBatteryLot(
    ::nn::sf::Out<::nn::settings::system::BatteryLot> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetCalibBinBatteryLotForSystemSettings(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetSerialNumber(
    ::nn::sf::Out<::nn::settings::system::SerialNumber> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetCalibBinSerialNumberForSystemSettings(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetNfcEnableFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsNfcEnableFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetNfcEnableFlag(bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsNfcEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetSleepSettings(
    ::nn::sf::Out<::nn::settings::system::SleepSettings> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsSleepSettings(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetSleepSettings(
    const ::nn::settings::system::SleepSettings& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsSleepSettings(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetWirelessLanEnableFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsWirelessLanEnableFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetWirelessLanEnableFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsWirelessLanEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetInitialLaunchSettings(
    ::nn::sf::Out<::nn::settings::system::InitialLaunchSettings> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsInitialLaunchSettings(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetInitialLaunchSettings(
    const ::nn::settings::system::InitialLaunchSettings& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsInitialLaunchSettings(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetDeviceNickName(
    ::nn::sf::Out<::nn::settings::system::DeviceNickName> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsDeviceNickName(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetDeviceNickName(
    const ::nn::settings::system::DeviceNickName& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsDeviceNickName(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetProductModel(
    ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetCalibBinProductModelForSystemSettings(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetLdnChannel(
    ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsLdnChannel(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetLdnChannel(int32_t value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsLdnChannel(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::AcquireTelemetryDirtyFlagEventHandle(
    ::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT
{
    ::nn::os::NativeHandle handle;
    NN_RESULT_DO(AcquireSystemSettingsTelemetryDirtyFlagEvent(&handle));
    outValue.Set(::nn::sf::NativeHandle(handle, false));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetTelemetryDirtyFlags(
    ::nn::sf::Out<::nn::settings::system::TelemetryDirtyFlagSet> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsTelemetryDirtyFlags(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetPtmBatteryLot(
    ::nn::sf::Out<::nn::settings::system::PtmBatteryLot> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetDeviceSettingsPtmBatteryLot(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetPtmBatteryLot(
    const nn::settings::system::PtmBatteryLot& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetDeviceSettingsPtmBatteryLot(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetPtmFuelGaugeParameter(
    ::nn::sf::Out<::nn::settings::system::PtmFuelGaugeParameter> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetDeviceSettingsPtmFuelGaugeParameter(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetPtmFuelGaugeParameter(
    const ::nn::settings::system::PtmFuelGaugeParameter& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetDeviceSettingsPtmFuelGaugeParameter(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetMiiAuthorId(
    ::nn::sf::Out<::nn::util::Uuid> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetApplicationSettingsMiiAuthorId(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::AcquireFatalDirtyFlagEventHandle(
    ::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT
{
    ::nn::os::NativeHandle handle;
    NN_RESULT_DO(AcquireSystemSettingsFatalDirtyFlagEvent(&handle));
    outValue.Set(::nn::sf::NativeHandle(handle, false));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetFatalDirtyFlags(
    ::nn::sf::Out<::nn::settings::system::FatalDirtyFlagSet> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsFatalDirtyFlags(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetAutoUpdateEnableFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsAutoUpdateEnableFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetAutoUpdateEnableFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsAutoUpdateEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetNxControllerSettings(
    ::nn::sf::Out<std::int32_t> outCount,
    const ::nn::sf::OutArray<::nn::settings::system::NxControllerSettings
        >& outValues) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsNxControllerSettings(
            outCount.GetPointer(),
            outValues.GetData(), static_cast<int32_t>(outValues.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetNxControllerSettings(
    const ::nn::sf::InArray<::nn::settings::system::NxControllerSettings
        >& values) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsNxControllerSettings(
            values.GetData(), static_cast<int32_t>(values.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetBatteryPercentageFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsBatteryPercentageFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetBatteryPercentageFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsBatteryPercentageFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetExternalRtcResetFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsExternalRtcResetFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetExternalRtcResetFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsExternalRtcResetFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetUsbFullKeyEnableFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsUsbFullKeyEnableFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetUsbFullKeyEnableFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsUsbFullKeyEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetBacklightSettingsEx(
    ::nn::sf::Out<::nn::settings::system::BacklightSettingsEx> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsBacklightSettings(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetBacklightSettingsEx(
    const ::nn::settings::system::BacklightSettingsEx& value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsBacklightSettings(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetHeadphoneVolumeWarningCount(
    ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsHeadphoneVolumeWarningCount(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetHeadphoneVolumeWarningCount(
    int32_t value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsHeadphoneVolumeWarningCount(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetBluetoothAfhEnableFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsBluetoothAfhEnableFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetBluetoothAfhEnableFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsBluetoothAfhEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetBluetoothBoostEnableFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsBluetoothBoostEnableFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetBluetoothBoostEnableFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsBluetoothBoostEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetInRepairProcessEnableFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetApplicationSettingsInRepairProcessFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetInRepairProcessEnableFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetApplicationSettingsInRepairProcessFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetHeadphoneVolumeUpdateFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsHeadphoneVolumeUpdateFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetHeadphoneVolumeUpdateFlag(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsHeadphoneVolumeUpdateFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::NeedsToUpdateHeadphoneVolume(
    ::nn::sf::Out<bool> outValue,
    ::nn::sf::Out<bool> outIsHighPowerAvailable,
    ::nn::sf::Out<int8_t> outVolume,
    bool isRestricted) NN_NOEXCEPT
{
    NN_RESULT_DO(
        NeedsToUpdateSystemSettingsHeadphoneVolume(
            outValue.GetPointer(),
            outIsHighPowerAvailable.GetPointer(),
            outVolume.GetPointer(),
            isRestricted));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetPushNotificationActivityModeOnSleep(
    ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsPushNotificationActivityModeOnSleep(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetPushNotificationActivityModeOnSleep(
    int32_t value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsPushNotificationActivityModeOnSleep(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetServiceDiscoveryControlSettings(
    ::nn::sf::Out<
        ::nn::settings::system::ServiceDiscoveryControlSettings> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetApplicationSettingsServiceDiscoveryControlSettings(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetServiceDiscoveryControlSettings(
    const nn::settings::system::ServiceDiscoveryControlSettings& value
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetApplicationSettingsServiceDiscoveryControlSettings(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetErrorReportSharePermission(
    ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsErrorReportSharePermission(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetErrorReportSharePermission(
    int32_t value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsErrorReportSharePermission(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetAppletLaunchFlags(
    ::nn::sf::Out<::nn::settings::system::AppletLaunchFlagSet> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsAppletLaunchFlags(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetAppletLaunchFlags(
    ::nn::settings::system::AppletLaunchFlagSet value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsAppletLaunchFlags(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetConsoleSixAxisSensorAccelerationBias(
    ::nn::sf::Out<
        ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsConsoleSixAxisSensorAccelerationBias(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetConsoleSixAxisSensorAccelerationBias(
    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias& value
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsConsoleSixAxisSensorAccelerationBias(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetConsoleSixAxisSensorAngularVelocityBias(
    ::nn::sf::Out<
        ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias
        > outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsConsoleSixAxisSensorAngularVelocityBias(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetConsoleSixAxisSensorAngularVelocityBias(
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias& value
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsConsoleSixAxisSensorAngularVelocityBias(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetConsoleSixAxisSensorAccelerationGain(
    ::nn::sf::Out<
        ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsConsoleSixAxisSensorAccelerationGain(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetConsoleSixAxisSensorAccelerationGain(
    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain& value
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsConsoleSixAxisSensorAccelerationGain(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetConsoleSixAxisSensorAngularVelocityGain(
    ::nn::sf::Out<
        ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain
        > outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsConsoleSixAxisSensorAngularVelocityGain(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetConsoleSixAxisSensorAngularVelocityGain(
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain& value
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsConsoleSixAxisSensorAngularVelocityGain(value));
    NN_RESULT_SUCCESS;
}

::nn::Result
SystemSettingsServer::GetConsoleSixAxisSensorAngularVelocityTimeBias(
    ::nn::sf::Out<
        ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityTimeBias
        > outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsConsoleSixAxisSensorAngularVelocityTimeBias(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result
SystemSettingsServer::SetConsoleSixAxisSensorAngularVelocityTimeBias(
    const ::nn::settings::system::
        ConsoleSixAxisSensorAngularVelocityTimeBias& value) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsConsoleSixAxisSensorAngularVelocityTimeBias(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetConsoleSixAxisSensorAngularAcceleration(
    ::nn::sf::Out<
        ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration
        > outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsConsoleSixAxisSensorAngularAcceleration(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetConsoleSixAxisSensorAngularAcceleration(
    const ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration& value
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsConsoleSixAxisSensorAngularAcceleration(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetKeyboardLayout(
    ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsKeyboardLayout(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetKeyboardLayout(int32_t value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsKeyboardLayout(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetWebInspectorFlag(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsWebInspectorFlag(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetAllowedSslHosts(
    ::nn::sf::Out<int32_t> outCount,
    const ::nn::sf::OutArray<::nn::settings::system::AllowedSslHost>&
        outValues) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsAllowedSslHosts(
            outCount.GetPointer(), outValues.GetData(), outValues.GetLength()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetHostFsMountPoint(
    ::nn::sf::Out<::nn::settings::system::HostFsMountPoint> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemSettingsHostFsMountPoint(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetRequiresRunRepairTimeReviser(
    ::nn::sf::Out<bool> outValue) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsRequiresRunRepairTimeReviser(
            outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetRequiresRunRepairTimeReviser(
    bool value) NN_NOEXCEPT
{
    NN_RESULT_DO(SetSystemSettingsRequiresRunRepairTimeReviser(value));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetBlePairingSettings(
    const ::nn::sf::InArray<
        ::nn::settings::system::BlePairingSettings>& values) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsBlePairingSettings(
            values.GetData(), static_cast<int32_t>(values.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetBlePairingSettings(
    ::nn::sf::Out<int32_t> outCount,
    const ::nn::sf::OutArray<
        ::nn::settings::system::BlePairingSettings>& outValues
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsBlePairingSettings(
            outCount.GetPointer(),
            outValues.GetData(), static_cast<int32_t>(outValues.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetRebootlessSystemUpdateVersion(
    ::nn::sf::Out<
        ::nn::settings::system::RebootlessSystemUpdateVersion> outValue
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(GetSystemRebootlessSystemUpdateVersion(outValue.GetPointer()));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::GetAccountOnlineStorageSettings(
    ::nn::sf::Out<int32_t> outCount,
    const ::nn::sf::OutArray<
        ::nn::settings::system::AccountOnlineStorageSettings>& outValues
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetSystemSettingsAccountOnlineStorageSettings(
            outCount.GetPointer(),
            outValues.GetData(), static_cast<int32_t>(outValues.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemSettingsServer::SetAccountOnlineStorageSettings(
    const ::nn::sf::InArray<
        ::nn::settings::system::AccountOnlineStorageSettings>& values
    ) NN_NOEXCEPT
{
    NN_RESULT_DO(
        SetSystemSettingsAccountOnlineStorageSettings(
            values.GetData(), static_cast<int32_t>(values.GetLength())));
    NN_RESULT_SUCCESS;
}

::nn::Result CreateSystemSettingsServerProxy(
    ::nn::sf::SharedPointer<ISystemSettingsServer>* pOutValue
    ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    *pOutValue = StaticObject<
        ::nn::sf::UnmanagedServiceObject<
            ISystemSettingsServer, SystemSettingsServer>>::Get().GetShared();
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
