﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_Mount.h>
#include <nn/fs/fs_File.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>

namespace nn { namespace settings { namespace detail {

//!< システムデータを扱うクラスです。
class SystemData final
{
private:
    //!< システムデータに格納できるファイルの名前の最大長
    static const int FileNameLengthMax = 31;

    //!< システムデータの識別子
    ::nn::ncm::SystemDataId m_SystemDataId;

    //!< システムデータのマウント名
    char m_MountName[::nn::fs::MountNameLengthMax + 1];

    //!< システムデータのファイルパス
    char m_FilePath[::nn::fs::MountNameLengthMax + 2 + FileNameLengthMax + 1];

public:
    SystemData() NN_NOEXCEPT;

    //!< システムデータの識別子を設定します。
    void SetSystemDataId(::nn::ncm::SystemDataId value) NN_NOEXCEPT;

    //!< システムデータのマウント名を設定します。
    void SetMountName(const char* name) NN_NOEXCEPT;

    //!< システムデータをマウントします。
    ::nn::Result Mount() NN_NOEXCEPT;

    //!< システムデータを読み込み権限で開きます。
    ::nn::Result OpenToRead() NN_NOEXCEPT;

    //!< システムデータを閉じます。
    void Close() NN_NOEXCEPT;

    //!< システムデータから読み込みます。
    ::nn::Result Read(int64_t offset, void* buffer, size_t size) NN_NOEXCEPT;
};

}}} // namespace nn::settings::detail
