﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/settings/system/settings_SystemApplication.h>

namespace nn { namespace settings { namespace detail {

::nn::Result GetLockScreenFlag(bool* pOutValue) NN_NOEXCEPT;

::nn::Result SetLockScreenFlag(bool value) NN_NOEXCEPT;

::nn::Result GetColorSetId(int32_t* pOutValue) NN_NOEXCEPT;

::nn::Result SetColorSetId(int32_t value) NN_NOEXCEPT;

::nn::Result GetBatteryPercentageFlag(bool* pOutValue) NN_NOEXCEPT;

::nn::Result SetBatteryPercentageFlag(bool value) NN_NOEXCEPT;

::nn::Result GetInitialLaunchSettings(
    ::nn::settings::system::InitialLaunchSettings* pOutValue) NN_NOEXCEPT;

::nn::Result SetInitialLaunchSettings(
    const ::nn::settings::system::InitialLaunchSettings& value) NN_NOEXCEPT;

::nn::Result GetDeviceNickName(
    ::nn::settings::system::DeviceNickName* pOutValue) NN_NOEXCEPT;

::nn::Result SetDeviceNickName(
    const ::nn::settings::system::DeviceNickName& value) NN_NOEXCEPT;

::nn::Result GetAppletLaunchFlags(
    ::nn::settings::system::AppletLaunchFlagSet* pOutValue) NN_NOEXCEPT;

::nn::Result SetAppletLaunchFlags(
    const ::nn::settings::system::AppletLaunchFlagSet& value) NN_NOEXCEPT;

::nn::Result GetQuestFlagForApplication(bool* pOutValue) NN_NOEXCEPT;

::nn::Result GetQuestFlagForSystemApplication(bool* pOutValue) NN_NOEXCEPT;

::nn::Result SetQuestFlag(bool value) NN_NOEXCEPT;

::nn::Result GetWirelessCertificationFileSize(uint64_t* pOutValue) NN_NOEXCEPT;

::nn::Result GetWirelessCertificationFile(
    uint64_t* pOutValue, void* outBuffer, size_t size) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
