﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace settings { namespace detail {

//!< spl のハードウェア種別
enum class SplHardwareType : int
{
    None,           //!< 未設定
    Icosa,          //!< Icosa
    IcosaMariko,    //!< Icosa-Mariko
    Copper,         //!< Copper
    Hoag,           //!< Hoag
};

//!< spl の Development フラグの値を返します。
bool IsSplDevelopment() NN_NOEXCEPT;

//!< spl のハードウェア種別を返します。
SplHardwareType GetSplHardwareType() NN_NOEXCEPT;

//!< spl の Quest フラグの値を返します。
bool IsSplRetailInteractiveDisplayStateEnabled() NN_NOEXCEPT;

}}} // namespace nn::settings::detail
