﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_IFactorySettingsServer.sfdl.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_BootImpl.h"
#include "settings_FactorySettingsServer.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetInitialSystemAppletProgramId(::nn::ncm::ProgramId* pOutValue
                                             ) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<ISystemSettingsServer>();
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetInitialSystemAppletProgramId(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetInitialSystemAppletProgramId(const ::nn::ncm::ProgramId& value
                                             ) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IFactorySettingsServer>();
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetInitialSystemAppletProgramId(value));

    NN_RESULT_SUCCESS;
}

::nn::Result GetOverlayDispProgramId(::nn::ncm::ProgramId* pOutValue
                                     ) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<ISystemSettingsServer>();
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetOverlayDispProgramId(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetOverlayDispProgramId(const ::nn::ncm::ProgramId& value
                                     ) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IFactorySettingsServer>();
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetOverlayDispProgramId(value));

    NN_RESULT_SUCCESS;
}

::nn::Result GetInRepairProcessEnableFlag(bool* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetInRepairProcessEnableFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetInRepairProcessEnableFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetInRepairProcessEnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetRequiresRunRepairTimeReviser(bool* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetRequiresRunRepairTimeReviser(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetRequiresRunRepairTimeReviser(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetRequiresRunRepairTimeReviser(value));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
