﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace sasbus {
namespace driver {
namespace detail {

// デバイス設定情報を格納した構造体
const DeviceSetting DeviceSettings[] =
{
    // Debug pad
    {
        SasbusDevice::SasbusDevice_Lsm6ds3,  // デバイス識別子
        3,                                   // バス番号 (0 始まりなので、 TRM の番号 - 1 )
        "spi4_0",                            // nne 向け識別子
         nne::spi::SPI_MODE_0,               // SPI のモード
         nne::spi::SpiBitsEight,             // Bit 設定
         8000000                             // クロック
    },

    // ここにデバイスを追記してください。
};

// 対応デバイスの数
const int DeviceNum = (sizeof(DeviceSettings) / sizeof(DeviceSettings[0]));

inline int GetDeviceSettingIndex(nn::sasbus::SasbusDevice device)
{
    for (int i = 0; i < DeviceNum; i++)
    {
        if (DeviceSettings[i].device == device)
        {
            return i;
        }
    }
    // すべてサーチしても見つからない場合は実装ミスなので ABORT する
    NN_ABORT("Not Found the device\n");
}


} // detail
} // driver
} // sasbus
} // nn
