﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pwm/driver/pwm_Lib.h>
#include <nn/pwm/driver/pwm_Channel.h>
#include <nn/pwm/driver/pwm_ChannelDev.h>

namespace nn {
namespace pwm {
namespace driver {

void Initialize() NN_NOEXCEPT
{
}
void Finalize() NN_NOEXCEPT
{
}
void OpenSessionForDev(ChannelSession* pOutSession, int channelIndex) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(channelIndex);
}
void OpenSession(ChannelSession* pOutSession, ChannelName name) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(name);
}
void CloseSession(ChannelSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}
void SetPeriod(ChannelSession* pSession, nn::TimeSpan period) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(period);
}
nn::TimeSpan GetPeriod(ChannelSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return nn::TimeSpan::FromSeconds(0);
}
void SetDuty(ChannelSession* pSession, int duty) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(duty);
}
int GetDuty(ChannelSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return 0;
}
void SetEnabled(ChannelSession* pSession, bool enable) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(enable);
}
bool GetEnabled(ChannelSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return false;
}

void SuspendAllChannels() NN_NOEXCEPT
{
}

void ResumeAllChannels() NN_NOEXCEPT
{
}

} // driver
} // pwm
} // nn
