﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/dd.h>
#include <nn/os.h>
#include <nn/util/util_BitPack.h>

namespace nn {
namespace pwm {
namespace driver {
namespace detail {

struct ChannelSessionImpl;

class DriverImplInterface
{
public:
    virtual void Open(ChannelSessionImpl& session) NN_NOEXCEPT = 0;
    virtual void Close(ChannelSessionImpl& session) NN_NOEXCEPT = 0;
    virtual void SetPeriod(ChannelSessionImpl& session, nn::TimeSpan period) NN_NOEXCEPT = 0;
    virtual nn::TimeSpan GetPeriod(ChannelSessionImpl& session) NN_NOEXCEPT = 0;
    virtual void SetDuty(ChannelSessionImpl& session, int duty) NN_NOEXCEPT = 0;
    virtual int GetDuty(ChannelSessionImpl& session) NN_NOEXCEPT = 0;
    virtual void SetEnabled(ChannelSessionImpl& session, bool enable) NN_NOEXCEPT = 0;
    virtual bool GetEnabled(ChannelSessionImpl& session) NN_NOEXCEPT = 0;
};

} // detail
} // driver
} // pwm
} // nn
