﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/dd.h>
#include <nn/os.h>
#include <nn/util/util_BitPack.h>

#include <nn/pwm/detail/pwm_Log.h>
#include <nn/pwm/driver/pwm_Lib.h>
#include <nn/pwm/driver/pwm_Channel.h>
#include <nn/pwm/driver/pwm_ChannelDev.h>

#include "pwm_ChannelSessionImpl-soc.tegra-x1.h"
#include "pwm_DriverImplInterface.h"

namespace nn {
namespace pwm {
namespace driver {
namespace detail {

class DriverImpl : public DriverImplInterface
{
public:
    virtual void Open(ChannelSessionImpl& session) NN_NOEXCEPT;
    virtual void Close(ChannelSessionImpl& session) NN_NOEXCEPT;
    virtual void SetPeriod(ChannelSessionImpl& session, nn::TimeSpan period) NN_NOEXCEPT;
    virtual nn::TimeSpan GetPeriod(ChannelSessionImpl& session) NN_NOEXCEPT;
    virtual void SetDuty(ChannelSessionImpl& session, int duty) NN_NOEXCEPT;
    virtual int GetDuty(ChannelSessionImpl& session) NN_NOEXCEPT;
    virtual void SetEnabled(ChannelSessionImpl& session, bool enable) NN_NOEXCEPT;
    virtual bool GetEnabled(ChannelSessionImpl& session) NN_NOEXCEPT;

    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void SuspendAllChannels() NN_NOEXCEPT;
    void ResumeAllChannels() NN_NOEXCEPT;
private:
    // TORIAEZU : 1 スレッドでしか動かない前提
    bool m_IsSuspended = false;

private:
    inline void CheckIsSuspended(ChannelSessionImpl& session)
    {
        NN_UNUSED(session);
        if (m_IsSuspended)
        {
            NN_DETAIL_PWM_WARN("Warning! pwm driver is suspended, but calling API from %d\n", session.channelIndex);
        }
    }
};

} // detail
} // driver
} // pwm
} // nn
