﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/TargetConfigs/build_Base.h>

#if   defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2)
    #include "pwm_ChannelNameMap-hardware.jetsontk2.h"
#elif defined(NN_BUILD_CONFIG_HARDWARE_NX)
    #include "pwm_ChannelNameMap-hardware.nx.h"
#else
    #error NN_BUILD_CONFIG_HARDWARE_ not selected or supported
#endif

namespace nn {
namespace pwm {
namespace driver {
namespace detail {

// サポートしていないチャンネルとして使用する番号
const int UnsupportedChannelIndex = -1;

// 公開 API の ChannelName を内部で使用するチャンネル番号に変換する
int GetChannelIndex(ChannelName targetName) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(targetName != ChannelName::ChannelName_Invalid,
        "ChannelName::ChannelName_Invalid cannot be specified");

    const int ChannelsCount = (sizeof(ChannelNameMap) / sizeof(ChannelNameMap[0]));
    for (int index = 0; index < ChannelsCount; ++index)
    {
        auto name = ChannelNameMap[index];
        if (name == targetName)
        {
            return index;
        }
    }

    return UnsupportedChannelIndex;
}

} // detail
} // driver
} // pwm
} // nn
