﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os.h>

#include "psm_BatteryState.h"
#include "psm_ChargeArbiter.h"
#include "psm_IChargerDriver.h"
#include "psm_IUsbPowerManager.h"
#include "psm_OverlayNotificationSender.h"
#include "psm_SessionManager.h"
#include "psm_SettingsHolder-spec.nx.h"
#include "psm_SupplyRouteManager.h"

namespace nn { namespace psm { namespace driver { namespace detail {

//! NX における USB の電力関連のマネージャー
class UsbPowerManagerStub final : public IUsbPowerManager
{
    NN_DISALLOW_COPY(UsbPowerManagerStub);
    NN_DISALLOW_MOVE(UsbPowerManagerStub);

public:
    UsbPowerManagerStub() NN_NOEXCEPT;

    virtual ~UsbPowerManagerStub() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Initialize(
        ChargeArbiter* pChargeArbiter,
        SupplyRouteManager* pSupplyRouteManager,
        BatteryState* pBatteryState,
        IChargerDriver* pChargerDriver,
        SessionManager* pSessionManager,
        OverlayNotificationSender* pNotificationSender,
        const SettingsHolder* pSettingsHolder) NN_NOEXCEPT NN_OVERRIDE;

    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

    //! OTG を許可します。
    virtual ::nn::Result AllowOtg() NN_NOEXCEPT NN_OVERRIDE;

    //! OTG を禁止します。
    virtual ::nn::Result DisallowOtg() NN_NOEXCEPT NN_OVERRIDE;

    //! 給電エミュレーションを有効にします。
    virtual ::nn::Result EnableEnoughPowerChargeEmulation() NN_NOEXCEPT NN_OVERRIDE;

    //! 給電エミュレーションを無効にします。
    virtual ::nn::Result DisableEnoughPowerChargeEmulation() NN_NOEXCEPT NN_OVERRIDE;

    //! USB の給電状態の更新イベントを提供します。
    virtual ::nn::os::SystemEventType* GetPowerEvent() NN_NOEXCEPT NN_OVERRIDE;

    //! USB Power Delivery からの通知イベントを提供します。
    virtual ::nn::os::SystemEventType* GetPowerDeliveryNoticeEvent() NN_NOEXCEPT NN_OVERRIDE;

    //! 給電エミュレーション変更後の給電状態の更新イベントを提供します。
    virtual ::nn::os::SystemEventType* GetEnoughPowerChargeEmulationEvent() NN_NOEXCEPT NN_OVERRIDE;

    //! USB の給電状態の更新を行います。
    virtual ::nn::Result Update() NN_NOEXCEPT NN_OVERRIDE;

    //! USB Power Delivery からの通知を処理します。
    virtual ::nn::Result ProcessPowerDeliveryNoticeEvent() NN_NOEXCEPT NN_OVERRIDE;

    //! 給電エミュレーション変更後の給電状態の更新を行います。
    virtual ::nn::Result ProcessEnoughPowerChargeEmulationEvent() NN_NOEXCEPT NN_OVERRIDE;

private:
    //! USB の給電状態の更新イベント
    ::nn::os::SystemEventType m_PowerEvent;

    //! USB Power Delivery からの通知イベント
    ::nn::os::SystemEventType m_PowerDeliveryNoticeEvent;

    //! 給電エミュレーション変更後の給電状態の更新イベント
    ::nn::os::SystemEventType m_EnoughPowerChargeEmulationEvent;
};

}}}} // namespace nn::psm::driver::detail
