﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

#include <nn/ovln/format/ovln_PowerManagementMessage.h>
#include <nn/ovln/ovln_SenderForOverlay.h>

#include "psm_IBatteryState.h"

namespace nn { namespace psm { namespace driver { namespace detail {

class OverlayNotificationSender final
{
    NN_DISALLOW_COPY(OverlayNotificationSender);
    NN_DISALLOW_MOVE(OverlayNotificationSender);

public:
    OverlayNotificationSender() NN_NOEXCEPT;

    ~OverlayNotificationSender() NN_NOEXCEPT;

    //! 初期化します。
    ::nn::Result Initialize(
        IBatteryState* pBatteryState) NN_NOEXCEPT;

    //! 終了処理をします。
    void Finalize() NN_NOEXCEPT;

    //! 充電器の状態が変化したことを通知します。
    ::nn::Result NotifyChargerStateChange() NN_NOEXCEPT;

    //! 電池残量が低いことを通知します。
    ::nn::Result NotifyLowBattery() NN_NOEXCEPT;

private:
    ::nn::Result Notify(::nn::ovln::SenderForOverlayType* pSender, uint32_t tag) NN_NOEXCEPT;

private:
    //! 電池状態管理
    IBatteryState* m_pBatteryState;

    //! 充電器状態変化オーバーレイ通知用オブジェクト
    ::nn::ovln::SenderForOverlayType m_OverlaySenderForChagerStateChange;

    //! 電池残量低下オーバーレイ通知用オブジェクト
    ::nn::ovln::SenderForOverlayType m_OverlaySenderForLowBattery;
};

}}}} // namespace nn::psm::driver::detail
