﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_TimeSpan.h>

#include <nn/os.h>

namespace nn { namespace psm { namespace driver { namespace detail {

// RetrySpan 間隔で約 TimeOutSpan の間リトライし続ける NN_RESULT_DO。
#define NN_DETAIL_PSM_DRIVER_RESULT_DO_RETRY(function) \
    do \
    { \
        const auto TimeOutSpan = ::nn::TimeSpan::FromMilliSeconds(10000); \
        const auto RetrySpan = ::nn::TimeSpan::FromMilliSeconds(20); \
        \
        auto totalSpan = ::nn::TimeSpan::FromMilliSeconds(0); \
        while  ( NN_STATIC_CONDITION(true) ) \
        { \
            auto result = (function); \
            if ( result.IsSuccess() ) \
            { \
                break; \
            } \
            totalSpan += RetrySpan; \
            if ( totalSpan >= TimeOutSpan) \
            { \
                NN_RESULT_DO(result); \
            } \
            ::nn::os::SleepThread(RetrySpan); \
        } \
    } while ( NN_STATIC_CONDITION(false) )

}}}} // namespace nn::psm::driver::detail
