﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/ovln/ovln_SenderForOverlay.h>

#include "psm_BatteryState.h"
#include "psm_IFuelGaugeDriver.h"
#include "psm_OverlayNotificationSender.h"
#include "psm_SettingsHolder-spec.nx.h"

namespace nn { namespace psm { namespace driver { namespace detail {

class BatteryChargeManager final
{
    NN_DISALLOW_COPY(BatteryChargeManager);
    NN_DISALLOW_MOVE(BatteryChargeManager);

public:
    BatteryChargeManager() NN_NOEXCEPT;

    ~BatteryChargeManager() NN_NOEXCEPT;

    //! 初期化します。
    ::nn::Result Initialize(
        IFuelGaugeDriver* pFuelGaugeDriver,
        BatteryState* pBatteryState,
        OverlayNotificationSender* pNotificationSender,
        const SettingsHolder* pSettingsHolder) NN_NOEXCEPT;

    //! 終了処理をします。
    void Finalize() NN_NOEXCEPT;

    //! 電池残量を更新し、必要に応じてオーバーレイ通知をおこないます。
    ::nn::Result Update(bool isPreviousLevelUsed) NN_NOEXCEPT;

private:
    enum class BatteryChargeLevel
    {
        Low1Percent,  //!< 電池残量が 1 パーセント
        Low5Percent,  //!< 電池残量が 5 パーセント
        Low15Percent, //!< 電池残量が 15 パーセント
        Enough,       //! 十分な電池残量
    };

private:
    ::nn::Result UpdateBatteryCharge() NN_NOEXCEPT;

    BatteryChargeLevel QuantizeBatteryCharge(int percentage) NN_NOEXCEPT;

private:
    //! 電池残量計ドライバ
    IFuelGaugeDriver* m_pFuelGaugeDriver;

    //! 電池状態
    BatteryState* m_pBatteryState;

    //! 電池残量レベル
    BatteryChargeLevel m_BatteryChargeLevel;

    //! オーバーレイ通知管理
    OverlayNotificationSender* m_pNotificationSender;

    //! デバッグ・プラットフォーム設定
    const SettingsHolder* m_pSettingsHolder;
};

}}}} // namespace nn::psm::driver::detail
